#include <ERRNO.H>
#include <STDARG.H>
#include <STRING.H>
#include <SPAD/IOCTL.H>
#include <SPAD/DEV.H>
#include <SPAD/SYNC.H>
#include <SPAD/LIBC.H>
#include <UNISTD.H>
#include <VALUES.H>
#include <SYS/TYPES.H>
#include <ARCH/BSF.H>

#include <SYS/IOCTL.H>
#include <SYS/SOUNDCARD.H>

#include <SPAD/IOC.H>

IOC_GEN_GET_MODE
IOC_GEN_GET_MODE_DATA
IOC_GEN_SET_MODE_INT

static int snd_sync(int h, unsigned long ioctl, va_list va)
{
	return get_mode(h, IOCTL_SND_SYNC,
		ioctl == SNDCTL_DSP_RESET ? PARAM_SND_SYNC_RESET :
		ioctl == SNDCTL_DSP_SYNC ? PARAM_SND_SYNC_SYNC :
		ioctl == SNDCTL_DSP_POST ? PARAM_SND_SYNC_POST :
		(KERNEL$SUICIDE("snd_sync: ioctl == %lu", ioctl), 0));
}

static int snd_speed(int h, unsigned long ioctl, va_list va)
{
	int r;
	int *speed = va_arg(va, int *);
	if (__unlikely(ioctl == SOUND_PCM_READ_RATE)) *speed = 0;
	if (__likely(*speed > 0)) {
		if (__unlikely(r = set_mode_int(h, "RATE", *speed))) return r;
	}
	if (__unlikely((r = get_mode(h, IOCTL_SND_GETRATE, 0)) < 0)) return r;
	if (__likely(*speed > 0) && __unlikely(r != *speed)) set_mode_int(h, "RATE", r);
	*speed = r;
	return 0;
}

static int snd_channels(int h, unsigned long ioctl, va_list va)
{
	int r;
	int *chan = va_arg(va, int *);
	if (__unlikely(ioctl == SOUND_PCM_READ_CHANNELS)) *chan = 0;
	if (__unlikely(ioctl == SNDCTL_DSP_STEREO)) {
		if (*chan < 0) *chan = 0;
		else if (!*chan) *chan = 1;
		else *chan = 2;
	}
	if (__likely(*chan > 0)) {
		if (__unlikely(r = set_mode_int(h, "CHANNELS", *chan))) return r;
	}
	if (__unlikely((r = get_mode(h, IOCTL_SND_GETCHANNELS, 0)) < 0)) return r;
	if (__likely(*chan > 0) && __unlikely(r != *chan)) set_mode_int(h, "CHANNELS", r);
	*chan = r;
	if (__unlikely(ioctl == SNDCTL_DSP_STEREO))
		(*chan)--;
	return 0;
}

static int snd_fmt(int h, unsigned long ioctl, va_list va)
{
	int r;
	int *fmt = va_arg(va, int *);
	if (__unlikely(ioctl == SOUND_PCM_READ_BITS)) *fmt = AFMT_QUERY;
	if (__likely(*fmt > AFMT_QUERY)) {
		if (__unlikely(*fmt & (*fmt - 1))) {
			*fmt = AFMT_QUERY;
			goto skip_set;
		}
		if (__unlikely(r = set_mode_int(h, "FORMAT", __BSR(*fmt)))) return r;
	}
	skip_set:
	if (__unlikely((r = get_mode(h, IOCTL_SND_GETFORMAT, 0)) < 0)) return r;
	if (__likely(*fmt > AFMT_QUERY) && *fmt != 1 << r) set_mode_int(h, "FORMAT", r);
	*fmt = 1 << r;
	return 0;
}

static int snd_subdivide(int h, unsigned long ioctl, va_list va)
{
	int val;
	int *div = va_arg(va, int *);
	if (!*div) {
		val = 0;
	} else {
		val = 1000 / *div;
		if (val <= 0) val = 1;
	}
	return set_mode_int(h, "SUBDIVIDE", val);
}

static int snd_setfragment(int h, unsigned long ioctl, va_list va)
{
	int r;
	int *frg = va_arg(va, int *);
	if (__unlikely(r = set_mode_int(h, "FRAGSIZE", *frg & 0xffff))) return r;
	if (__unlikely(r = set_mode_int(h, "FRAGS", (*frg >> 16) & 0x7fff))) return r;
	return 0;
}

static int snd_get_val(int h, unsigned long ioctl, va_list va)
{
	int r;
	int *data = va_arg(va, int *);
	r = get_mode(h, ioctl == SNDCTL_DSP_GETFMTS ? IOCTL_SND_GETFORMATMASK :
			ioctl == SNDCTL_DSP_GETCAPS ? IOCTL_SND_GETCAPS :
			ioctl == SNDCTL_DSP_GETTRIGGER ? IOCTL_SND_GETTRIGGER :
			ioctl == SNDCTL_DSP_GETODELAY ? IOCTL_SND_GETODELAY :
			(KERNEL$SUICIDE("snd_get_val: ioctl == %lu", ioctl), 0)
			, 0);
	if (__unlikely(r < 0)) return r;
	*data = r;
	return 0;
}

static int snd_getspace(int h, unsigned long ioctl, va_list va)
{
	audio_buf_info *info = va_arg(va, audio_buf_info *);
	return get_mode_data(h, IOCTL_SND_GETSPACE, __likely(ioctl == SNDCTL_DSP_GETOSPACE) ? PARAM_SND_GETSPACE_PLAYBACK : PARAM_SND_GETSPACE_RECORD, info, sizeof(audio_buf_info));
}

static int snd_getblksize(int h, unsigned long ioctl, va_list va)
{
	int r;
	int *blksize = va_arg(va, int *);
	audio_buf_info info;
	r = get_mode_data(h, IOCTL_SND_GETSPACE, PARAM_SND_GETSPACE_CURRENT, &info, sizeof(audio_buf_info));
	if (__unlikely(r < 0)) return r;
	*blksize = info.fragsize;
	return 0;
}

static int snd_nonblock(int h, unsigned long ioctl, va_list va)
{
	int fl;
	fl = fcntl(h, F_GETFL);
	if (__unlikely(fl < 0)) return fl;
	return fcntl(h, F_SETFL, fl | O_NONBLOCK);
}

static int snd_settrigger(int h, unsigned long ioctl, va_list va)
{
	int *trig = va_arg(va, int *);
	return get_mode(h, IOCTL_SND_SETTRIGGER, *trig);
}

static int snd_getptr(int h, unsigned long ioctl, va_list va)
{
	count_info *ci = va_arg(va, count_info *);
	return get_mode_data(h, IOCTL_SND_GETPTR,
		ioctl == SNDCTL_DSP_GETIPTR ? PARAM_SND_GETPTR_RECORD :
		ioctl == SNDCTL_DSP_GETOPTR ? PARAM_SND_GETPTR_PLAYBACK :
		(KERNEL$SUICIDE("snd_getptr: ioctl == %lu", ioctl), 0)
		, ci, sizeof(count_info));
}

static int snd_geterror(int h, unsigned long ioctl, va_list va)
{
	audio_errinfo *ae = va_arg(va, audio_errinfo *);
	return get_mode_data(h, IOCTL_SND_GETERROR, 0, ae, sizeof(audio_errinfo));
}

static int snd_setduplex(int h, unsigned long ioctl, va_list va)
{
	int r;
	r = get_mode(h, IOCTL_SND_GETCAPS, 0);
	if (__unlikely(r < 0)) return r;
	if (__unlikely(!(r & DSP_CAP_DUPLEX))) {
		errno = EINVAL;
		return -1;
	}
	return 0;
}

static int snd_mixread(int h, unsigned long ioctl, va_list va)
{
	int r;
	int *val = va_arg(va, int *);
	r = get_mode(h, IOCTL_SND_MIXREAD, ioctl - _SOUND_MIXER_READ);
	if (__unlikely(r < 0)) return r;
	*val = r;
	return 0;
}

static int snd_mixwrite(int h, unsigned long ioctl, va_list va)
{
	int r;
	int *val = va_arg(va, int *);
	if (*val > (MAXINT >> PARAM_MIX_DATA_SHIFT)) {
		errno = EINVAL;
		return -1;
	}
	r = get_mode(h, IOCTL_SND_MIXWRITE, (*val << PARAM_MIX_DATA_SHIFT) | (ioctl - _SOUND_MIXER_WRITE));
	if (__unlikely(r < 0)) return r;
	*val = r;
	return 0;
}

static int snd_einval(int h, unsigned long ioctl, va_list va)
{
	errno = EINVAL;
	return -1;
}

static const struct ioc_entry ioc_table[] = {
	SNDCTL_DSP_RESET,	2,	snd_sync,
	/*SNDCTL_DSP_SYNC,	1,	snd_sync,*/
	SNDCTL_DSP_SPEED,	1,	snd_speed,
	SNDCTL_DSP_STEREO,	1,	snd_channels,
	SNDCTL_DSP_GETBLKSIZE,	1,	snd_getblksize,
	SNDCTL_DSP_SETFMT,	1,	snd_fmt,
	SNDCTL_DSP_CHANNELS,	1,	snd_channels,
	SNDCTL_DSP_POST,	1,	snd_sync,
	SNDCTL_DSP_SUBDIVIDE,	1,	snd_subdivide,
	SNDCTL_DSP_SETFRAGMENT,	1,	snd_setfragment,
	SNDCTL_DSP_GETFMTS,	1,	snd_get_val,
	SNDCTL_DSP_GETOSPACE,	2,	snd_getspace,
	/*SNDCTL_DSP_GETISPACE,	1,	snd_getspace,*/
	SNDCTL_DSP_NONBLOCK,	1,	snd_nonblock,
	SNDCTL_DSP_GETCAPS,	2,	snd_get_val,
	/*SNDCTL_DSP_GETTRIGGER,1,	snd_get_val,*/
	SNDCTL_DSP_SETTRIGGER,	1,	snd_settrigger,
	SNDCTL_DSP_GETIPTR,	2,	snd_getptr,
	/*SNDCTL_DSP_GETOPTR,	1,	snd_getptr,*/
	SNDCTL_DSP_MAPINBUF,	3,	snd_einval,
	/*SNDCTL_DSP_MAPOUTBUF,	1,	snd_einval,*/
	/*SNDCTL_DSP_SETSYNCRO,	1,	snd_einval,*/
	SNDCTL_DSP_SETDUPLEX,	1,	snd_setduplex,
	SNDCTL_DSP_GETODELAY,	1,	snd_get_val,
	SNDCTL_DSP_GETERROR,	1,	snd_geterror,
	SOUND_PCM_READ_RATE,	1,	snd_speed,
	SOUND_PCM_READ_CHANNELS,1,	snd_channels,
	SOUND_PCM_READ_BITS,	1,	snd_fmt,
	SOUND_PCM_READ_FILTER,	2,	snd_einval,
	/*SOUND_PCM_WRITE_FILTER,1,	snd_einval,*/
	_SOUND_MIXER_READ,	_SOUND_MIXER_RW_SPACE,	snd_mixread,
	_SOUND_MIXER_WRITE,	_SOUND_MIXER_RW_SPACE,	snd_mixwrite,
	0,	0,	NULL,
};

const struct ioc_entry * const IOC$TABLE = ioc_table;

translate_unx_fn IOC$TRANSLATE_UNX;

const char *IOC$TRANSLATE_UNX(const char *str, const char **to_free)
{
	if (__likely(!strcmp(str, "/dev/dsp")) || __unlikely(!strcmp(str, "/dev/audio")) || __likely(!strcmp(str, "/dev/mixer")))
		return "SND$DSP:/";
	return NULL;
}

