#ifndef __HCI_OHCIREG_H
#define __HCI_OHCIREG_H

#include <SYS/TYPES.H>

#define OHCI_REGSPACE		4096

#define OHCI_PAGE_SIZE		4096

#define HcRevision		0x00
#define  HcRevision_REV			0x000000ff
#define   HcRevision_REV_val			0x10
#define HcControl		0x04
#define  HcControl_CBSR			0x00000003
#define  HcControl_PLE			0x00000004
#define  HcControl_IE			0x00000008
#define  HcControl_CLE			0x00000010
#define  HcControl_BLE			0x00000020
#define  HcControl_HCFS			0x000000c0
#define   HcControl_HCFS_RESET			0x00
#define   HcControl_HCFS_RESUME			0x40
#define   HcControl_HCFS_OPERATIONAL		0x80
#define   HcControl_HCFS_SUSPEND		0xc0
#define  HcControl_IR			0x00000100
#define  HcControl_RWC			0x00000200
#define  HcControl_RWE			0x00000400
#define HcCommandStatus		0x08
#define  HcCommandStatus_HCR		0x00000001
#define  HcCommandStatus_CLF		0x00000002
#define  HcCommandStatus_BLF		0x00000004
#define  HcCommandStatus_OCR		0x00000008
#define  HcCommandStatus_SOC		0x00030000
#define HcInterruptStatus	0x0c
#define  HcInterruptStatus_SO		0x00000001
#define  HcInterruptStatus_WDH		0x00000002
#define  HcInterruptStatus_SF		0x00000004
#define  HcInterruptStatus_RD		0x00000008
#define  HcInterruptStatus_UE		0x00000010
#define  HcInterruptStatus_FNO		0x00000020
#define  HcInterruptStatus_RHSC		0x00000040
#define  HcInterruptStatus_OC		0x40000000
#define HcInterruptEnable	0x10
#define  HcInterruptEnable_SO		0x00000001
#define  HcInterruptEnable_WDH		0x00000002
#define  HcInterruptEnable_SF		0x00000004
#define  HcInterruptEnable_RD		0x00000008
#define  HcInterruptEnable_UE		0x00000010
#define  HcInterruptEnable_FNO		0x00000020
#define  HcInterruptEnable_RHSC		0x00000040
#define  HcInterruptEnable_OC		0x40000000
#define  HcInterruptEnable_MIE		0x80000000
#define HcInterruptDisable	0x14
#define  HcInterruptDisable_SO		0x00000001
#define  HcInterruptDisable_WDH		0x00000002
#define  HcInterruptDisable_SF		0x00000004
#define  HcInterruptDisable_RD		0x00000008
#define  HcInterruptDisable_UE		0x00000010
#define  HcInterruptDisable_FNO		0x00000020
#define  HcInterruptDisable_RHSC	0x00000040
#define  HcInterruptDisable_OC		0x40000000
#define  HcInterruptDisable_MIE		0x80000000

#define HcHCCA			0x18
#define HcPeriodicCurrentED	0x1c
#define HcControlHeadED		0x20
#define HcControlCurrentED	0x24
#define HcBulkHeadED		0x28
#define HcBulkCurrentED		0x2c
#define HcDoneHead		0x30

#define HcFmInterval		0x34
#define  HcFmInterval_FI		0x00003fff
#define  HcFmInterval_FSMPS		0x7fff0000
#define  HcFmInterval_FIT		0x80000000
#define HcFmRemaining		0x38
#define  HcFmRemaining_FR		0x00003fff
#define  HcFmRemaining_FRT		0x80000000
#define HcFmNumber		0x3c
#define  HcFmNumber_FN			0x0000ffff
#define HcPeriodicStart		0x40
#define  HcPeriodicStart_PS		0x00003fff
#define HcLSTreshold		0x44
#define  HcLSTreshold_LST		0x00000fff

#define HcRhDescriptorA		0x48
#define  HcRhDescriptorA_NDP		0x000000ff
#define  HcRhDescriptorA_PSM		0x00000100
#define  HcRhDescriptorA_NPS		0x00000200
#define  HcRhDescriptorA_DT		0x00000400
#define  HcRhDescriptorA_OCPM		0x00000800
#define  HcRhDescriptorA_NOCP		0x00001000
#define  HcRhDescriptorA_POTPGT		0xff000000
#define HcRhDescriptorB		0x4c
#define  HcRhDescriptorB_DR		0x0000fffe
#define  HcRhDescriptorB_PPCM		0xfffe0000
#define HcRhStatus		0x50
#define  HcRhStatus_LPS			0x00000001
#define  HcRhStatus_OCI			0x00000002
#define  HcRhStatus_DRWE		0x00008000
#define  HcRhStatus_LPSC		0x00010000
#define  HcRhStatus_OCIC		0x00020000
#define  HcRhStatus_CRWE		0x80000000
#define HcRhPortStatus		0x54
#define  HcRhPortStatus_CCS		0x00000001
#define  HcRhPortStatus_PES		0x00000002
#define  HcRhPortStatus_PSS		0x00000004
#define  HcRhPortStatus_POCI		0x00000008
#define  HcRhPortStatus_PRS		0x00000010
#define  HcRhPortStatus_PPS		0x00000100
#define  HcRhPortStatus_LSDA		0x00000200
#define  HcRhPortStatus_CSC		0x00010000
#define  HcRhPortStatus_PESC		0x00020000
#define  HcRhPortStatus_PSSC		0x00040000
#define  HcRhPortStatus_OCIC		0x00080000
#define  HcRhPortStatus_PRSC		0x00100000

#define HccaInterruptTableSize		32

typedef struct {
	__u32 HccaInterruptTable[HccaInterruptTableSize];
	__u16 HccaFrameNumber;
	__u16 HccaPad1;
	__u32 HccaDoneHead;
	__u8 reserved[120];
} HCCA;

typedef struct {
	__u32 flags;
	__u32 tail;
	__u32 head;
	__u32 next_ed;
} HW_ED;

#define ED_FA		0x0000007f
#define ED_EN		0x00000780
#define ED_D		0x00001800
#define  ED_D_TD		0x00000000
#define  ED_D_OUT		0x00000800
#define  ED_D_IN		0x00001000
#define ED_S		0x00002000
#define ED_K		0x00004000
#define ED_F		0x00008000
#define ED_MPS		0x07ff0000

#define ED_QH_H		0x00000001
#define ED_QH_C		0x00000002
#define ED_QH_ADDR	0xfffffff0

typedef struct {
	__u32 flags;
	__u32 ptr;
	__u32 next_td;
	__u32 end;
} HW_TD;

#define TD_R		0x00040000
#define TD_DP		0x00180000
#define  TD_DP_SETUP		0x00000000
#define  TD_DP_OUT		0x00080000
#define  TD_DP_IN		0x00100000
#define TD_DI		0x00e00000
#define  TD_DI_0		0x00000000
#define  TD_DI_MAX		0x00c00000
#define  TD_DI_NONE		0x00e00000
#define TD_T		0x03000000
#define  TD_T_DATA0	0x02000000
#define  TD_T_DATA1	0x03000000
#define  TD_T_DATA_SEL	0x02000000
#define  TD_T_DATA_BIT	0x01000000
#define TD_EC		0x0c000000
#define TD_CC		0xf0000000

typedef struct {
	__u32 flags;
	__u32 ptr;
	__u32 next_td;
	__u32 end;
	__u16 offs[8];
} HW_TD_ISO;

#define TDI_SF		0x0000ffff
#define TDI_DI		0x00e00000
#define TDI_FC		0x07000000
#define TDI_CC		0xf0000000

	/* software identifier ... unused for both TD and TD_ISO */
#define TD_ISO		0x00010000

#endif
