#ifndef __HCI_UHCIREG_H
#define __HCI_UHCIREG_H

#include <SYS/TYPES.H>

#define UHCI_USBCMD			0x00
#define  UHCI_USBCMD_MAXP			0x0080
#define  UHCI_USBCMD_CF				0x0040
#define  UHCI_USBCMD_SWDBG			0x0020
#define  UHCI_USBCMD_FGR			0x0010
#define  UHCI_USBCMD_EGSM			0x0008
#define  UHCI_USBCMD_GRESET			0x0004
#define  UHCI_USBCMD_HCRESET			0x0002
#define  UHCI_USBCMD_RS				0x0001
#define UHCI_USBSTS			0x02
#define  UHCI_USBSTS_RESERVED			0xffc0
#define  UHCI_USBSTS_HC_HALTED			0x0020
#define  UHCI_USBSTS_HC_PROCESS_ERROR		0x0010
#define  UHCI_USBSTS_HC_SYSTEM_ERROR		0x0008
#define  UHCI_USBSTS_RESUME_DETECT		0x0004
#define  UHCI_USBSTS_USBERRINT			0x0002
#define  UHCI_USBSTS_USBINT			0x0001
#define UHCI_USBINTR			0x04
#define  UHCI_USBINTR_SHORT_PACKET		0x0008
#define  UHCI_USBINTR_IOC			0x0004
#define  UHCI_USBINTR_RESUME			0x0002
#define  UHCI_USBINTR_TIMEOUT_CRC		0x0001
#define UHCI_FRNUM			0x06
#define  UHCI_FRNUM_MASK			0x07ff
#define UHCI_FLBASEADD			0x08
#define UHCI_SOFMOD			0x0c
#define  UHCI_SOFMOD_MASK			0x7f
#define  UHCI_SOFMOD_DEFAULT			0x40
#define UHCI_PORTSC			0x10
#define  UHCI_PORTSC_SUSPEND			0x1000
#define  UHCI_PORTSC_OC_CHANGE			0x0800
#define  UHCI_PORTSC_OC				0x0400
#define  UHCI_PORTSC_RESET			0x0200
#define  UHCI_PORTSC_LOW_SPEED			0x0100
#define  UHCI_PORTSC_RESERVED_ONE		0x0080
#define  UHCI_PORTSC_RESUME_DETECT		0x0040
#define  UHCI_PORTSC_LINE_STATUS_D_MINUS	0x0020
#define  UHCI_PORTSC_LINE_STATUS_D_PLUS		0x0010
#define  UHCI_PORTSC_ENABLE_CHANGE		0x0008
#define  UHCI_PORTSC_ENABLE			0x0004
#define  UHCI_PORTSC_CONNECT_CHANGE		0x0002
#define  UHCI_PORTSC_CONNECT			0x0001
#define  UHCI_PORTSC_RWC			0x080a
#define  UHCI_PORTSC_WZ				0xe000
#define UHCI_PORTSC_NEXT		0x02
#define UHCI_DEFAULT_PORTS		0x02
#define UHCI_MAX_PORTS			0x07

#define UHCI_PCI_SBRN			0x60
#define UHCI_PCI_LEGSUP			0xc0
#define  UHCI_PCI_LEGSUP_A20PTS			0x8000
#define  UHCI_PCI_LEGSUP_USBPIRQDEN		0x2000
#define  UHCI_PCI_LEGSUP_USBIRQS		0x1000
#define  UHCI_PCI_LEGSUP_TBY64W			0x0800
#define  UHCI_PCI_LEGSUP_TBY64R			0x0400
#define  UHCI_PCI_LEGSUP_TBY60W			0x0200
#define  UHCI_PCI_LEGSUP_TBY60R			0x0100
#define  UHCI_PCI_LEGSUP_SMIEPTE		0x0080
#define  UHCI_PCI_LEGSUP_PSS			0x0040
#define  UHCI_PCI_LEGSUP_A20PTEN		0x0020
#define  UHCI_PCI_LEGSUP_USBSMIEN		0x0010
#define  UHCI_PCI_LEGSUP_64WEN			0x0008
#define  UHCI_PCI_LEGSUP_64REN			0x0004
#define  UHCI_PCI_LEGSUP_60WEN			0x0002
#define  UHCI_PCI_LEGSUP_60REN			0x0001
#define  UHCI_PCI_LEGSUP_HAS_BIOS		0x00bf
#define  UHCI_PCI_LEGSUP_RWC			0x8f00
#define  UHCI_PCI_LEGSUP_DEFAULT		0x2000
#define  UHCI_PCI_LEGSUP_RO			0x5040

#define UHCI_ADDR_MASK		0xFFFFFFF0
#define UHCI_ADDR_VF		0x00000004
#define UHCI_ADDR_Q		0x00000002
#define UHCI_ADDR_T		0x00000001

typedef struct {
	__u32 link;
	__u32 flags1;
	__u32 flags2;
	__u32 ptr;
} HW_TD;

#define TD_FLAGS1_SPD			0x20000000
#define TD_FLAGS1_C_ERR_NO_LIMIT	0x00000000
#define TD_FLAGS1_C_ERR_1		0x08000000
#define TD_FLAGS1_C_ERR_2		0x10000000
#define TD_FLAGS1_C_ERR_3		0x18000000
#define TD_FLAGS1_LS			0x04000000
#define TD_FLAGS1_ISO			0x02000000
#define TD_FLAGS1_IOC			0x01000000
#define TD_FLAGS1_STATUS_ACTIVE		0x00800000
#define TD_FLAGS1_STATUS_STALLED	0x00400000
#define TD_FLAGS1_STATUS_BUFFER_ERROR	0x00200000
#define TD_FLAGS1_STATUS_BABBLE		0x00100000
#define TD_FLAGS1_STATUS_NAK		0x00080000
#define TD_FLAGS1_STATUS_CRC_TIMEOUT	0x00040000
#define TD_FLAGS1_STATUS_BITSTUFF_ERROR	0x00020000
#define TD_FLAGS1_ACTLEN		0x000007ff

#define TD_FLAGS2_MAXLEN		0xffe00000
#define TD_FLAGS2_D			0x00080000
#define TD_FLAGS2_ENDPT			0x00078000
#define TD_FLAGS2_DEVICE_ADDRESS	0x00007f00
#define TD_FLAGS2_PID			0x000000ff
#define TD_FLAGS2_PID_SETUP		0x0000002d
#define TD_FLAGS2_PID_IN		0x00000069
#define TD_FLAGS2_PID_OUT		0x000000e1

typedef struct {
	__u32 head_link;
	__u32 element_link;
} HW_QH;

#define N_FRAME_LIST		1024

typedef struct {
	__u32 addr[N_FRAME_LIST];
} FRAME_LIST;

#endif
