#include <STRING.H>
#include <SPAD/SYNC.H>
#include <SPAD/LIBC.H>

#include "USB.H"

const unsigned USB$SIZEOF_USB = sizeof(USB);

int USB$HC_REGISTER(USB *usb, const USB_HC_OPERATIONS *op, char *dev_name, int errorlevel, char *plug)
{
	int r;
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_ZERO)))
		KERNEL$SUICIDE("USB$HC_REGISTER AT SPL %08X", KERNEL$SPL);
	if (__unlikely(strlen(plug) >= __MAX_STR_LEN))
		KERNEL$SUICIDE("USB$HC_REGISTER: PLUG SCRIPT HAS LENGTH %ld", (unsigned long)strlen(plug));
	memset(usb, 0, sizeof(USB));
	usb->op = op;
	usb->dev_name = dev_name;
	usb->errorlevel = errorlevel;
	MTX_INIT(&usb->addr0lock, "USB$ADDR0LOCK");
	INIT_XLIST(&usb->running);
	strcpy(usb->plug, plug);
	RAISE_SPL(SPL_USB);
	usb->zero_ctrl_lowspeed = op->alloc_endpoint(usb, USB_LOW_SPEED, USB_EP_CTRL, 0, 0, 8, 0, 1, 64);
	if (__unlikely(__IS_ERR(usb->zero_ctrl_lowspeed))) {
		r = __PTR_ERR(usb->zero_ctrl_lowspeed);
		goto ret0;
	}
	usb->zero_ctrl_fullspeed = op->alloc_endpoint(usb, USB_FULL_SPEED, USB_EP_CTRL, 0, 0, 64, 0, 1, 64);
	if (__unlikely(__IS_ERR(usb->zero_ctrl_fullspeed))) {
		r = __PTR_ERR(usb->zero_ctrl_fullspeed);
		goto ret1;
	}
	r = USB_INIT_ROOT_HUB(usb);
	if (__unlikely(r)) goto ret2;
	LOWER_SPL(SPL_ZERO);
	return 0;

	ret2:
	op->free_endpoint(usb->zero_ctrl_fullspeed);
	ret1:
	op->free_endpoint(usb->zero_ctrl_lowspeed);
	ret0:
	LOWER_SPL(SPL_ZERO);
	return r;
}

int USB$HC_PREPARE_UNREGISTER(USB *usb)
{
	unsigned i, j;
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_ZERO)))
		KERNEL$SUICIDE("USB$HC_PREPARE_UNREGISTER AT SPL %08X", KERNEL$SPL);
	RAISE_SPL(SPL_USB);
	usb->shutting_down = 1;
	for (i = 0; i < USB_MAX_ADDRESSES; i++) {
		USB_DEV *dev = i ? usb->devices[i] : &usb->root_hub;
		if (dev && dev->n_attached > 0) {
			USB_DEV_CFG *cfg;
			if (__unlikely(dev->active_cfg == -1))
				KERNEL$SUICIDE("USB$HC_PREPARE_UNREGISTER: NON-CONFIGURED DEVICE %s ATTACHED (HOST %s)", USB_DEV_ID(dev), usb->dev_name);
			cfg = &dev->confs[dev->active_cfg];
			for (j = 0; j < cfg->n_ifaces; j++) if (cfg->ifaces[j].attached && !cfg->ifaces[j].hub) {
				usb->shutting_down = 0;
				LOWER_SPL(SPL_ZERO);
				return -EBUSY;
			}
		}
	}
	usb->shutting_down = 2;
	for (i = 0; i < USB_MAX_ADDRESSES; i++) {
		USB_DEV *dev;
		j = 0;
		test_again:
		dev = i ? usb->devices[i] : &usb->root_hub;
		if (dev && dev->n_attached > 0) {
			USB_DEV_CFG *cfg;
			cfg = &dev->confs[dev->active_cfg];
			for (; j < cfg->n_ifaces; j++) if (cfg->ifaces[j].hub) {
				/* this may deallocate the device */
				HUB_ERROR(cfg->ifaces[j].hub, -ECONNABORTED);
				j++;
				goto test_again;
			}
		}
	}
	wait_for_hubs:
	KERNEL$SLEEP(1);
	for (i = 0; i < USB_MAX_ADDRESSES; i++) {
		USB_DEV *dev = i ? usb->devices[i] : &usb->root_hub;
		if (dev && dev->n_attached > 0) {
			goto wait_for_hubs;
		}
	}
	for (i = 1; i < USB_MAX_ADDRESSES; i++) {
		USB_DEV *dev = usb->devices[i];
		if (__unlikely(dev != NULL)) {
			if (__unlikely(dev->n_attached))
				KERNEL$SUICIDE("USB$HC_PREPARE_UNREGISTER: ATTACH LEAKED ON DEVICE %u:%d", i, usb->devices[i]->n_attached);
			USB_FREE_DEVICE(dev);
		}
		if (usb->devices[i]) KERNEL$SUICIDE("USB$HC_PREPARE_UNREGISTER: FAILED TO RELEASE DEVICE %u", i);
	}
	USBPLUG_UNLOAD(usb);
	usb->op->free_endpoint(usb->zero_ctrl_fullspeed);
	usb->op->free_endpoint(usb->zero_ctrl_lowspeed);
	LOWER_SPL(SPL_ZERO);
	return 0;
}

void USB$HC_UNREGISTER(USB *usb)
{
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_ZERO)))
		KERNEL$SUICIDE("USB$HC_UNREGISTER AT SPL %08X", KERNEL$SPL);
	RAISE_SPL(SPL_USB);
	if (__unlikely(!usb->shutting_down))
		KERNEL$SUICIDE("USB$HC_UNREGISTER: USB$HC_PREPARE_UNREGISTER NOT CALLED");
	USB_FREE_DEVICE(&usb->root_hub);
	LOWER_SPL(SPL_ZERO);
}

int USB$HC_DCTL(void *ptr, void **unload, const char * const argv[])
{
	USB *usb = ptr;
	_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "%s: SYNTAX ERROR", usb->dev_name);
	return -EBADSYN;
}
