#ifndef __LIB_USB_H
#define __LIB_USB_H

#include <SPAD/LIST.H>
#include <SPAD/TIMER.H>
#include <SPAD/WQ.H>

#include <SPAD/USBHC.H>

#define USB_CTRL_TIMEOUT		(5 * JIFFIES_PER_SECOND)
#define USB_CTRL_RETRIES		3
#define USB_CTRL_RESET_WAIT		(2 * JIFFIES_PER_SECOND)
#define USB_HUB_TIMEOUT			(JIFFIES_PER_SECOND)
#define USB_HUB_RETRIES			2
#define USB_HUB_DEBOUNCE_STEP		(JIFFIES_PER_SECOND / 40)
#define USB_HUB_DEBOUNCE_STABLE		TIMEOUT_JIFFIES(JIFFIES_PER_SECOND / 10)
#define USB_HUB_DEBOUNCE_TIMEOUT	(JIFFIES_PER_SECOND * 3 / 2)
#define USB_HUB_ROOT_RESET_WAIT		TIMEOUT_JIFFIES(JIFFIES_PER_SECOND / 20)
#define USB_HUB_SHORT_RESET_WAIT	TIMEOUT_JIFFIES(JIFFIES_PER_SECOND / 50)
#define USB_HUB_LONG_RESET_WAIT		TIMEOUT_JIFFIES(JIFFIES_PER_SECOND / 5)
#define USB_HUB_RESET_N_WAIT		5
#define USB_HUB_RESET_N_TRIES		2
#define USB_SET_ADDRESS_WAIT		TIMEOUT_JIFFIES(JIFFIES_PER_SECOND / 500)

#define USB_MAX_ENDPOINTS		16
#define USB_MAX_ADDRESSES		128
#define USB_MAX_CTRL_REQUEST_SIZE	65535
#define USB_MAX_PIPE0_SIZE		USB_MAX_CTRL_REQUEST_SIZE

typedef struct __usb_dev_cfg USB_DEV_CFG;
typedef struct __usb_dev_endpoint USB_DEV_ENDPOINT;
typedef struct __usb_attach_cmd USB_ATTACH_CMD;
typedef struct __event EVENT;

#define USB_CMD_ATTACH		0

struct __usb_dev {
	USB *usb;
	int addr;
	int speed;
	USB_DESCRIPTOR_DEVICE dev_desc;

	USB_ENDPOINT *in_endpoints[USB_MAX_ENDPOINTS];
	USB_ENDPOINT *out_endpoints[USB_MAX_ENDPOINTS];
	int active_cfg;
	USB_DEV_CFG *confs;
	int n_confs;

	int max_ifaces;

	int n_attached;

	int hub_addr;
	int hub_port;			/* -1 for inactive device */

	int pktsize;
};

struct __usb_dev_cfg {
	USB_DEV *dev;
	char valid;
	char disabled;
	USB_DESCRIPTOR_CONFIGURATION cfg_desc;
	__u8 *descs;
	unsigned descs_size;
	unsigned descs_allocated_size;
	USB_DEV_INTERFACE *ifaces;
	unsigned n_ifaces;
};

struct __usb_dev_interface {
	USB_DEV_CFG *cfg;
	char attached;
	char disabled;
	EVENT *unplug_code;
	void *hub;
	USB_DESCRIPTOR_INTERFACE *desc;
	USB_DEV_ENDPOINT *endpts;
	unsigned n_endpts;
};

struct __usb_dev_endpoint {
	USB_DESCRIPTOR_ENDPOINT *desc;
	char used;
};

struct __usb {
	const USB_HC_OPERATIONS *op;
	USB_DEV root_hub;
	char *dev_name;
	char errorlevel;
	char remote_wakeup;
	char shutting_down;
	MTX addr0lock;
	USB_DEV *devices[USB_MAX_ADDRESSES];
	XLIST_HEAD running;
	USB_ENDPOINT *zero_ctrl_lowspeed;
	USB_ENDPOINT *zero_ctrl_fullspeed;
	char plug[__MAX_STR_LEN];
};

struct __usb_args {
	char *controller;
	int address;
	int configuration;
	int interface;
	int altsetting;
};

struct __usb_attach_cmd {
	const USB_ARGS *args;
	int (*test)(USB_DEV_INTERFACE *, long);
	long data;
	USB_DEV_INTERFACE *result;
};

char *USB_DEV_ID(USB_DEV *dev);
unsigned USB_CFG_NUM(USB_DEV_CFG *cfg);
unsigned USB_CFG_ORDER(USB_DEV_CFG *cfg);
char *USB_IF_ID(USB_DEV_INTERFACE *iface);

int USB_GET_DESCRIPTOR(USB_DEV *dev, __u8 rqtype, __u8 dt, __u8 idx, __u16 windex, void *ptr, unsigned len, unsigned min_len, int flags);
void *USB_FIND_DESCRIPTOR(USB_DEV_CFG *cfg, unsigned *off, __u8 type, unsigned length, int boundary);
int USB_FIND_ADDRESS(USB *usb);
int USB_INIT_DEVICE(USB_DEV *dev, int *a0locked);
int USB_REINIT_DEVICE(USB_DEV *dev, int *a0locked);
void USB_FREE_DEVICE(USB_DEV *dev);
int USB_ENDPOINT_TYPECODE(USB_DESCRIPTOR_ENDPOINT *desc);

void USB_BUG_EARLY_GET_DEVICE_DESCRIPTOR(USB_DEV *dev, USB_ENDPOINT *ep, unsigned *new_pktsize);

void HUB_ERROR(void *hub, int error);
int USB_HUB_WAIT_FOR_RESET(USB_DEV *dev);
int USB_INIT_ROOT_HUB(USB *usb);

void USBPLUG_EVENT(USB_DEV *dev);
void USBPLUG_CLEAR_IFACE_UNPLUG(USB_DEV_INTERFACE *iface);
int USBPLUG_SET_IFACE_UNPLUG(USB_DEV_INTERFACE *iface, const char *dev_name);
void USBPLUG_UNPLUG(USB_DEV *dev);
void USBPLUG_UNLOAD(USB *usb);

#endif
