#include <STDLIB.H>
#include <STDARG.H>
#include <STRING.H>
#include <SPAD/SYNC.H>
#include <SPAD/LIBC.H>

#include <SPAD/SHELL.H>

#include "USB.H"

char *USB$HC_DEFAULT_PLUG_SCRIPT = "LIB.:/USBPLUG.CMD";

struct __event {
	LIST_ENTRY list;
	SHRCRQ shrcrq;
	USB *usb;
	char code[1];
};

static AST_STUB RUN_CODE_DONE;

static EVENT *USB_ALLOC_CODE(USB *usb, ...)
{
	SHCCRQ shccrq;
	EVENT *e;
	va_list args;
	size_t len;
	char *s, *ptr;
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_USB)))
		KERNEL$SUICIDE("USB_RUN_CODE AT SPL %08X", KERNEL$SPL);
	len = 0;
	va_start(args, usb);
	while ((s = va_arg(args, char *))) len += strlen(s);
	va_end(args);
	e = __sync_malloc(sizeof(EVENT) + len);
	if (__unlikely(!e)) return __ERR_PTR(-ENOMEM);
	e->usb = usb;
	ptr = e->code;
	va_start(args, usb);
	while ((s = va_arg(args, char *))) ptr = stpcpy(ptr, s);
	va_end(args);
	SYNC_IO_CANCELABLE(&shccrq, SHELL$CREATE_CONTEXT);
	if (__unlikely(shccrq.status < 0)) {
		free(e);
		return __ERR_PTR(shccrq.status);
	}
	SHELL$SET_TTY(shccrq.ctx, SHELL_CONSOLE_OUTPUT, SHELL_CONSOLE_OUTPUT, SHELL_CONSOLE_OUTPUT, 0, 0, 0, 0);
	e->shrcrq.fn = RUN_CODE_DONE;
	e->shrcrq.ctx = shccrq.ctx;
	e->shrcrq.ptr = e->code;
	e->shrcrq.len = strlen(e->code);
	e->shrcrq.narg = 0;
	e->shrcrq.arg = NULL;
	return e;
}

static void USB_FREE_CODE(EVENT *e)
{
	SHELL$DESTROY_CONTEXT(e->shrcrq.ctx);
	free(e);
}

static void USB_RUN_CODE(EVENT *e)
{
	USB *usb = e->usb;
	ADD_TO_XLIST(&usb->running, &e->list);
	CALL_IORQ(&e->shrcrq, SHELL$RUN_COMMANDS);
}

static DECL_AST(RUN_CODE_DONE, SPL_USB, SHRCRQ)
{
	EVENT *e = GET_STRUCT(RQ, EVENT, shrcrq);
	DEL_FROM_LIST(&e->list);
	USB_FREE_CODE(e);
	RETURN;
}

void USBPLUG_EVENT(USB_DEV *dev)
{
	EVENT *e;
	char addr[4];
	if (__unlikely(!*dev->usb->plug)) return;
	_snprintf(addr, sizeof addr, "%d", dev->addr);
	e = USB_ALLOC_CODE(dev->usb, "LET USB_CTRL=\"", dev->usb->dev_name, "\"; LET USB_ADDRESS=\"", addr, "\"; CALL ", dev->usb->plug, NULL);
	if (__unlikely(__IS_ERR(e))) return;
	USB_RUN_CODE(e);
}

void USBPLUG_CLEAR_IFACE_UNPLUG(USB_DEV_INTERFACE *iface)
{
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_USB)))
		KERNEL$SUICIDE("USBPLUG_CLEAR_IFACE_UNPLUG AT SPL %08X", KERNEL$SPL);
	if (iface->unplug_code) {
		USB_FREE_CODE(iface->unplug_code);
		iface->unplug_code = NULL;
	}
}

int USBPLUG_SET_IFACE_UNPLUG(USB_DEV_INTERFACE *iface, const char *dev_name)
{
	EVENT *e;
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_USB)))
		KERNEL$SUICIDE("USBPLUG_SET_IFACE_UNPLUG AT SPL %08X", KERNEL$SPL);
	if (!iface->attached)
		KERNEL$SUICIDE("USBPLUG_SET_IFACE_UNPLUG: IFACE NOT ATTACHED");
	e = USB_ALLOC_CODE(iface->cfg->dev->usb, "DMAN UNLOAD ", dev_name, NULL);
	if (__unlikely(__IS_ERR(e))) return __PTR_ERR(e);
	USBPLUG_CLEAR_IFACE_UNPLUG(iface);
	iface->unplug_code = e;
	return 0;
}

void USBPLUG_UNPLUG(USB_DEV *dev)
{
	int i, j;
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_USB)))
		KERNEL$SUICIDE("USBPLUG_UNPLUG AT SPL %08X", KERNEL$SPL);
	for (i = 0; i < dev->n_confs; i++) {
		USB_DEV_CFG *cfg = &dev->confs[i];
		for (j = 0; j < cfg->n_ifaces; j++) {
			USB_DEV_INTERFACE *iface = &cfg->ifaces[j];
			if (iface->unplug_code) {
				USB_RUN_CODE(iface->unplug_code);
				iface->unplug_code = NULL;
			}
		}
	}
}

void USBPLUG_UNLOAD(USB *usb)
{
	EVENT *e;
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_USB)))
		KERNEL$SUICIDE("USBPLUG_UNLOAD AT SPL %08X", KERNEL$SPL);
	XLIST_FOR_EACH(e, &usb->running, EVENT, list) {
		KERNEL$CIO((IORQ *)(void *)&e->shrcrq);
	}
	while (__unlikely(!XLIST_EMPTY(&usb->running))) KERNEL$SLEEP(1);
}
