#include <SPAD/SYSLOG.H>
#include <SPAD/SYNC.H>
#include <SPAD/TIMER.H>

#include "USB.H"

typedef struct {
	USB_CTRL_REQUEST rq;
	WQ wq;
	TIMER t;
	USB_ENDPOINT *endpt;
	char timed_out;
	char done;
} USB_SYNC_CTRL_REQUEST;

static AST_STUB USB_SYNC_CTRL_RETURNED;
static void USB_SYNC_CTRL_TIMEOUT(TIMER *t);

/* request < 0 means that this is non-ctrl request */

int USB$SYNC_CTRL(USB_ENDPOINT *endpt, int request, __u16 w_value, __u16 w_index, unsigned long w_length, void *ptr, int flags, u_jiffies_lo_t timeout, int retries, USB_DEV_INTERFACE *reset_iface, unsigned long *transferred)
{
	USB_SYNC_CTRL_REQUEST rq;
#if __DEBUG >= 1
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_USB)))
		KERNEL$SUICIDE("USB$SYNC_CTRL AT SPL %08X", KERNEL$SPL);
#endif
	rq.rq.fn = USB_SYNC_CTRL_RETURNED;
	if (request >= 0) {
		rq.rq.setup.request = __16CPU2LE(request);
		rq.rq.setup.w_value = __16CPU2LE(w_value);
		rq.rq.setup.w_index = __16CPU2LE(w_index);
		rq.rq.setup.w_length = __16CPU2LE(w_length);
	}
	rq.rq.v.vspace = &KERNEL$VIRTUAL;
	rq.rq.flags = flags;
	WQ_INIT(&rq.wq, "USB$SYNC_CTRL_TIMEOUT");
	rq.t.fn = USB_SYNC_CTRL_TIMEOUT;
	rq.endpt = endpt;
	again:
	rq.rq.v.ptr = (unsigned long)ptr;
	rq.rq.v.len = w_length;
	INIT_TIMER(&rq.t);
	rq.timed_out = 0;
	rq.done = 0;
	KERNEL$SET_TIMER(timeout, &rq.t);
	endpt->prepare(endpt, (USB_REQUEST *)(void *)&rq.rq);
	endpt->post((USB_REQUEST *)(void *)&rq.rq);
	if (__likely(!(flags & USB_SYNC_CTRL_NOINTR))) {
		int r = WQ_WAIT_SYNC_CANCELABLE(&rq.wq);
		if (__unlikely(r)) {
			if (__likely(!rq.done)) {
				endpt->cancel((USB_REQUEST *)(void *)&rq.rq);
				WQ_WAIT_SYNC(&rq.wq);
			}
		}
	} else {
		WQ_WAIT_SYNC(&rq.wq);
	}
	KERNEL$DEL_TIMER(&rq.t);
	if (__unlikely(rq.rq.status < 0)) {
		if (__unlikely(!__IS_ERR(__ERR_PTR(rq.rq.status))))
			KERNEL$SUICIDE("USB$SYNC_CTRL: HOST CONTROLLER RETURNED NEGATIVE NON-ERROR STATUS: %lX", rq.rq.status);
		if (__unlikely(rq.timed_out) && rq.rq.status == -EINTR) {
			rq.rq.status = -ETIMEDOUT;
			if (!(flags & USBRQ_QUIET_ERROR)) {
				if (endpt->usb->errorlevel >= 1)
					KERNEL$SYSLOG(__SYSLOG_NET_ERROR, endpt->usb->dev_name, "DEVICE TIMED OUT ON CONTROL COMMAND %04X:%04X:%04X:%04X", (unsigned)__16LE2CPU(rq.rq.setup.request), (unsigned)__16LE2CPU(rq.rq.setup.w_value), (unsigned)__16LE2CPU(rq.rq.setup.w_index), (unsigned)__16LE2CPU(rq.rq.setup.w_length));
			}
		}
		if (rq.rq.status != -EINTR && --retries >= 0) {
			if (reset_iface && (!retries || rq.rq.status == -ETIMEDOUT)) {
				USB_RESET_RQ reset;
				reset.iface = reset_iface;
				reset.wait_time = USB_CTRL_RESET_WAIT;
				if (__likely(!(flags & USB_SYNC_CTRL_NOINTR))) {
					SYNC_IO_CANCELABLE(&reset, USB$RESET_PORT);
				} else {
					SYNC_IO(&reset, USB$RESET_PORT);
				}
				reset_iface = NULL;
			}
			goto again;
		}
	}
	if (transferred) *transferred = rq.rq.v.len;
	/*__debug_printf("returned: %ld, %ld\n", rq.rq.status, rq.rq.v.len);*/
	if (__likely(rq.rq.status >= 0)) {
		if (request >= 0) {
			if (__unlikely(rq.rq.v.len < sizeof(USB_CTRL_SETUP))) return -EPROTO;
			return rq.rq.v.len - sizeof(USB_CTRL_SETUP);
		}
		return rq.rq.v.len;
	}
	return rq.rq.status;
}

static DECL_AST(USB_SYNC_CTRL_RETURNED, SPL_USB, USB_CTRL_REQUEST)
{
	USB_SYNC_CTRL_REQUEST *rq = GET_STRUCT(RQ, USB_SYNC_CTRL_REQUEST, rq);
	rq->done = 1;
	WQ_WAKE_ALL_PL(&rq->wq);
	RETURN;
}

static void USB_SYNC_CTRL_TIMEOUT(TIMER *t)
{
	USB_SYNC_CTRL_REQUEST *rq;
	LOWER_SPL(SPL_USB);
	rq = GET_STRUCT(t, USB_SYNC_CTRL_REQUEST, t);
	SET_TIMER_NEVER(&rq->t);
	rq->timed_out = 1;
	rq->endpt->cancel((USB_REQUEST *)(void *)&rq->rq);
}

