#ifndef __GLOB_H
#define	__GLOB_H

#include <SYS/TYPES.H>

__BEGIN_DECLS

struct stat;

typedef struct {
	int gl_pathc;
	int gl_matchc;
	int gl_offs;
	int gl_flags;
	char **gl_pathv;
	int (*gl_errfunc)(__const__ char *, int);
	void *(*gl_opendir)(__const__ char *);
	struct dirent *(*gl_readdir)(void *);
	void (*gl_closedir)(void *);
	int (*gl_lstat)(__const__ char *, struct stat *);
	int (*gl_stat)(__const__ char *, struct stat *);
} glob_t;

#define	GLOB_APPEND	0x0001
#define	GLOB_DOOFFS	0x0002
#define	GLOB_ERR	0x0004
#define	GLOB_MARK	0x0008
#define	GLOB_NOCHECK	0x0010
#define	GLOB_NOSORT	0x0020
#define	GLOB_ALTDIRFUNC	0x0040
#define GLOB_BRACE	0x0080
#define	GLOB_MAGCHAR	0x0100
#define	GLOB_NOMAGIC	0x0200
#define	GLOB_TILDE	0x0800
#define	GLOB_LIMIT	0x1000
#define	GLOB_NOESCAPE	0x2000
#define GLOB_PERIOD	0x4000
#define GLOB_ONLYDIR	0x8000

#define GLOB_MAXPATH	GLOB_LIMIT
#define	GLOB_ABEND	GLOB_ABORTED

#define	GLOB_NOSPACE	(-1)
#define	GLOB_ABORTED	(-2)
#define	GLOB_NOMATCH	(-3)
#define	GLOB_NOSYS	(-4)

#define _GLOB_DEFAULT_LIMIT	65536

int glob(__const__ char *, int, int (*)(__const__ char *, int), glob_t *);
void globfree(glob_t *);
int glob_pattern_p(const char *pattern, int quote);

__END_DECLS

#endif
