#ifndef __GPM_H
#define __GPM_H

#include <SYS/TYPES.H>
#include <SYS/TIME.H>
#include <STDIO.H>

__BEGIN_DECLS

#define GPM_XTERM_ON printf("%c[?1001s%c[?1000h", 27, 27), fflush(stdout)
#define GPM_XTERM_OFF printf("%c[?1000l%c[?1001r", 27, 27), fflush(stdout)

#define GPM_B_NONE	0
#define GPM_B_RIGHT	1
#define GPM_B_MIDDLE	2
#define GPM_B_LEFT	4
#define GPM_B_FOURTH	8
#define GPM_B_UP	16
#define GPM_B_DOWN	32
#define GPM_B_FIFTH	64
#define GPM_B_SIXTH	128

enum Gpm_Etype {
	GPM_MOVE = 1,
	GPM_DRAG = 2,
	GPM_DOWN = 4,
	GPM_UP = 8,
	GPM_SINGLE = 16,
	GPM_DOUBLE = 32,
	GPM_TRIPLE = 64,
	GPM_MFLAG = 128,
	GPM_HARD = 256,
	GPM_ENTER = 512,
	GPM_LEAVE = 1024,
	GPM_SMOOTH = 2048,
};
#define GPM_HAVE_SMOOTH

#define GPM_BARE_EVENTS(flag)	((flag) & (0x0f | GPM_ENTER | GPM_LEAVE))

#define Gpm_StrictSingle(flag)	(((flag) & GPM_SINGLE) && !((flag) & GPM_MFLAG))
#define Gpm_AnySingle(flag)	((flag) & GPM_SINGLE)
#define Gpm_StrictDouble(flag)	(((flag) & GPM_DOUBLE) && !((flag) & GPM_MFLAG))
#define Gpm_AnyDouble(flag)	((flag) & GPM_DOUBLE)
#define Gpm_StrictTriple(flag)	(((flag) & GPM_TRIPLE) && !((flag) & GPM_MFLAG))
#define Gpm_AnyTriple(flag)	((flag) & GPM_TRIPLE)

enum Gpm_Margin {
	GPM_TOP = 1,
	GPM_BOT = 2,
	GPM_LFT = 4,
	GPM_RGT = 8
};

typedef struct Gpm_Event {
	unsigned short buttons, modifiers;
	unsigned short vc;
	short dx, dy, x, y;
	enum Gpm_Etype type;
	int clicks;
	enum Gpm_Margin margin;
	short wdx, wdy;
} Gpm_Event;

typedef int Gpm_Handler(Gpm_Event *, void *);

#define GPM_MAGIC 0x47706D4C

typedef struct Gpm_Connect {
	unsigned short eventMask, defaultMask;
	unsigned short minMod, maxMod;
	int pid;
	int vc;
	struct Gpm_Connect *next;
} Gpm_Connect;

typedef struct Gpm_Roi {
	short xMin,xMax;
	short yMin,yMax;
	unsigned short minMod, maxMod;
	unsigned short eventMask;
	unsigned short owned;
	Gpm_Handler *handler;
	void *clientdata;
	struct Gpm_Roi *prev;
	struct Gpm_Roi *next;
} Gpm_Roi;

extern int gpm_flag, gpm_fd, gpm_hflag, gpm_morekeys;

extern int gpm_zerobased;
extern int gpm_visiblepointer;
extern int gpm_mx, gpm_my;
extern struct timeval gpm_timeout;

extern Gpm_Handler *gpm_handler;
extern void *gpm_data;

extern Gpm_Handler *gpm_roi_handler;
extern void *gpm_roi_data;

extern Gpm_Roi *gpm_roi;
extern Gpm_Roi *gpm_current_roi;

extern int Gpm_Open(Gpm_Connect *, int);
extern int Gpm_Close(void);
extern int Gpm_GetEvent(Gpm_Event *);
extern int Gpm_CharsQueued(void);
extern int Gpm_Getc(FILE *);
#define Gpm_Getchar() Gpm_Getc(stdin)
extern int Gpm_Repeat(int millisec);
extern int Gpm_FitValuesM(int *x, int *y, int margin);
#define Gpm_FitValues(x,y) Gpm_FitValuesM((x),(y),-1);

#define Gpm_FitEvent(ePtr)						\
do {									\
	int _x, _y;							\
	if ((ePtr)->margin && ((ePtr)->type & (GPM_DRAG | GPM_UP))) {	\
		_x = (ePtr)->x;						\
		_y = (ePtr)->y;						\
		Gpm_FitValuesM(&_x, &_y, (ePtr)->margin);		\
		(ePtr)->x = _x;						\
		(ePtr)->y = _y;						\
	}								\
} while (0)

extern int Gpm_DrawPointer(int x, int y, int fd);

extern int gpm_consolefd;

#define GPM_DRAWPOINTER(ePtr) (Gpm_DrawPointer((ePtr)->x, (ePtr)->y, gpm_consolefd))

Gpm_Handler Gpm_HandleRoi;
Gpm_Roi *Gpm_PushRoi(int x, int y, int X, int Y, int mask, Gpm_Handler *fun, void *xtradata);
Gpm_Roi *Gpm_PopRoi(Gpm_Roi *which);
Gpm_Roi *Gpm_RaiseRoi(Gpm_Roi *which, Gpm_Roi *before);
Gpm_Roi *Gpm_LowerRoi(Gpm_Roi *which, Gpm_Roi *after);
Gpm_Roi *Gpm_UseRoi(Gpm_Roi *new);

extern int Gpm_Wgetch(void *);
#define Gpm_Getch() (Gpm_Wgetch(NULL))

char *Gpm_GetLibVersion(int *where);
char *Gpm_GetServerVersion(int *where);
int Gpm_GetSnapshot(Gpm_Event *ePtr);

__END_DECLS

#endif
