#ifndef __LIMITS_H
#define __LIMITS_H

#include <SYS/TYPES.H>
#include <ARCH/LIMITS.H>

#define CHAR_BIT	8
#define MB_LEN_MAX	8
#define SCHAR_MIN	(-128)
#define SCHAR_MAX	127
#define UCHAR_MAX	255
#define CHAR_MIN	((char)-1 == -1 ? SCHAR_MIN : 0)
#define CHAR_MAX	((char)-1 == -1 ? SCHAR_MAX : UCHAR_MAX)

#define UQUAD_MAX	((u_quad_t)-1)
#define QUAD_MAX	(~QUAD_MIN)
#define QUAD_MIN	((quad_t)1 << 63)

#define SIZE_MAX	SIZE_T_MAX
#define SSIZE_MAX	SSIZE_T_MAX
#define SSIZE_MIN	SSIZE_T_MIN

/* system limits */

#define _POSIX_ARG_MAX		4096
#define _POSIX_CHILD_MAX	6
#define _POSIX_LINK_MAX		8
#define _POSIX_MAX_CANON	255
#define _POSIX_MAX_INPUT	255
#define _POSIX_NGROUPS_MAX	0
#define _POSIX_OPEN_MAX		16
#define _POSIX_NAME_MAX		14
#define _POSIX_PATH_MAX		255
#define _POSIX_PIPE_BUF		512
#define _POSIX_SSIZE_MAX	32767
#define _POSIX_STREAM_MAX	8
#define _POSIX_TZNAME_MAX	3

#define _POSIX2_BC_BASE_MAX	99
#define _POSIX2_BC_DIM_MAX	2048
#define _POSIX2_BC_SCALE_MAX	99
#define _POSIX2_BC_STRING_MAX	1000
#define _POSIX2_EQUIV_CLASS_MAX	2
#define _POSIX2_EXPR_NEST_MAX	32
#define _POSIX2_LINE_MAX	2048
#define _POSIX2_RE_DUP_MAX	255

#define NR_OPEN		INT_MAX

#define NGROUPS_MAX	1
#define ARG_MAX		(64 * 1024 * 1024)
#define CHILD_MAX	INT_MAX
#define OPEN_MAX	(__INT_SGN_BIT >> 3)
#define LINK_MAX	1
#define MAX_CANON	255
#define MAX_INPUT	255
#define NAME_MAX	255
#define PATH_MAX	4096
#define PIPE_BUF	512
#define DEV_BSIZE	512

#define STREAMS_MAX	OPEN_MAX

/* copied and modified from glibc */

/*#define NBBY		CHAR_BIT*/
#define MAXSYMLINKS	5
#define CANBSIZ		MAX_CANON
#define NCARGS		ARG_MAX
#define MAXPATHLEN	PATH_MAX
#define NOFILE		OPEN_MAX
#define MAXHOSTNAMELEN	256

#endif
