#ifndef __MALLOC_H
#define __MALLOC_H

#include <SYS/TYPES.H>
#include <ARCH/MALLOC.H>
#include <ARCH/BSF.H>

__BEGIN_DECLS

#ifndef __static__
#define __static__ static
#endif

void *__MALLOC_ATTR__ KERNEL$__CALLOC(size_t __s);
void KERNEL$__MALLOC_ERROR(void);

#if defined(__NO_INLINES)
void *__MALLOC_ATTR__ calloc(size_t __n, size_t __size);
#else
__static__ __finline__ void *__MALLOC_ATTR__ calloc(size_t __n, size_t __size)
{
	size_t __ss;
	if (__is_constant(__size)) {
		if (__size > 1 && __unlikely(__n > (size_t)-1 / __size)) {
			goto __me;
		}
		__ss = __n * __size;
	} else if (__is_constant(__n)) {
		if (__n > 1 && __unlikely(__size > (size_t)-1 / __n)) {
			goto __me;
		}
		__ss = __n * __size;
	} else {
		__calloc_multiply
	}
	return KERNEL$__CALLOC(__ss);
	__me:
	KERNEL$__MALLOC_ERROR();
	return NULL;
}
#endif

#if defined(__NO_INLINES) || defined(__COMMON_C)
void *__MALLOC_ATTR__ malloc(size_t __size);
#else
void *__MALLOC_ATTR__ ___malloc_alias(size_t __size);
void *__MALLOC_ATTR__ ___malloc_const(size_t __size_m1, unsigned __log2);
__static__ __finline__ void *__MALLOC_ATTR__ malloc(size_t __size)
{
	if (__is_constant(__size)) {
		size_t __x_size = (__size - 1) | (__MIN_SLAB_SIZE - 1);
		return ___malloc_const(__x_size, __BSR_CONST(__x_size));
	} else {
		return ___malloc_alias(__size);
	}
}
#endif

void *__MALLOC_ATTR__ realloc(void *__s, size_t __size);
void *__MALLOC_ATTR__ reallocf(void *__s, size_t __size);
size_t __alloc_size(void *__s);
void *__MALLOC_ATTR__ memalign(size_t __align, size_t __s);
void *__MALLOC_ATTR__ valloc(size_t __size);
void *__MALLOC_ATTR__ __sync_malloc(size_t __size);
void *__MALLOC_ATTR__ __sync_calloc(size_t __n, size_t __size);
void *__MALLOC_ATTR__ __sync_realloc(void *__s, size_t __size);
void *__MALLOC_ATTR__ __sync_reallocf(void *__s, size_t __size);
void *__MALLOC_ATTR__ __sync_memalign(size_t __align, size_t __size);

void free(void *__s);

void KERNEL$HEAP_CHECK(__const__ char *__msg);

__END_DECLS

#endif
