/* md5.h
 * This file is a part of the Links program, released under GPL.
 */

#ifndef _MD5_H_
#define _MD5_H_

#ifdef __SPAD__
#include <SYS/TYPES.H>
#else
#include <sys/types.h>
#endif

#define MD5_HASHBYTES 16

typedef struct MD5Context {
	u_int32_t buf[4];
	u_int32_t bits[2];
	unsigned char in[64];
} MD5_CTX;

__BEGIN_DECLS

extern void   MD5Init(MD5_CTX *);
extern void   MD5Update(MD5_CTX *, unsigned char const *, unsigned);
extern void   MD5Final(unsigned char [MD5_HASHBYTES], MD5_CTX *);
extern void   MD5Transform(u_int32_t [4], u_int32_t const [16]);
extern char * MD5End(MD5_CTX *, char *);
extern char * MD5File(const char *, char *);
extern char * MD5Data (const void *, unsigned int, char *);

__END_DECLS

#endif /* !_MD5_H_ */
