#ifndef __NETINET_DHCP_H
#define __NETINET_DHCP_H

#include <SYS/TYPES.H>
#include <NETINET/IN.H>

#define BOOTP_SERVER_PORT		67
#define BOOTP_CLIENT_PORT		68

#define BOOTP_PAD			0
#define BOOTP_END			255

#define BOOTP_SUBNET_MASK		1
#define BOOTP_TIME_OFFSET		2
#define BOOTP_ROUTERS			3
#define BOOTP_TIME_SERVERS		4
#define BOOTP_NAME_SERVERS		5
#define BOOTP_DNS_SERVERS		6
#define BOOTP_LOG_SERVERS		7
#define BOOTP_QUOTE_OF_THE_DAY_SERVERS	8
#define BOOTP_LPR_SERVERS		9
#define BOOTP_IMPRESS_SERVERS		10
#define BOOTP_RESOURCE_LOCATION_SERVERS	11
#define BOOTP_HOST_NAME			12
#define BOOTP_BOOT_FILE_SIZE		13
#define BOOTP_MERIT_DUMP_FILE		14
#define BOOTP_DOMAIN_NAME		15
#define BOOTP_SWAP_SERVER		16
#define BOOTP_ROOT_PATH			17
#define BOOTP_EXTENSIONS_PATH		18

#define BOOTP_IP_FORWARDING		19
#define BOOTP_NON_LOCAL_SOURCE_ROUTING	20
#define BOOTP_POLICY_FILTERS		21
#define BOOTP_MAXIMUM_REASSEMBLY_SIZE	22
#define BOOTP_TIME_TO_LOVE		23	/* this typo is pretty cute */
/* BTW. I never made love to a woman, because I have a schizoid personality
disorder :-( */
#define BOOTP_PATH_MTU_AGING_TIMEOUT	24
#define BOOTP_PATH_MTU_PLATEAU_TABLE	25

#define BOOTP_MTU			26
#define BOOTP_ALL_SUBNETS_ARE_LOCAL	27
#define BOOTP_BROADCAST_ADDRESS		28
#define BOOTP_PERFORM_MASK_DISCOVERY	29
#define BOOTP_MASK_SUPPLIER		30
#define BOOTP_PERFORM_ROUTER_DISCOVERY	31
#define BOOTP_ROUTER_SOLICITATION_ADDR	32
#define BOOTP_STATIC_ROUTES		33

#define BOOTP_TRAILER_ENCAPSULATION	34
#define BOOTP_ARP_CACHE_TIMEOUT		35
#define BOOTP_ETHERNET_ENCAPSULATION	36

#define BOOTP_TCP_DEFAULT_TTL		37
#define BOOTP_TCP_KEEPALIVE_INTERVAL	38
#define BOOTP_TCP_KEEPALIVE_GARBAGE	39

#define BOOTP_NIS_DOMAIN		40
#define BOOTP_NIS_SERVERS		41
#define BOOTP_NTP_SERVERS		42
#define BOOTP_VENDOR_SPECIFIC		43
#define BOOTP_NETBIOS_NAME_SERVERS	44
#define BOOTP_NETBIOS_DD_SERVERS	45
#define BOOTP_NETBIOS_NODE_TYPE		46
#define BOOTP_NETBIOS_SCOPE		47
#define BOOTP_X_WINDOW_FONT_SERVERS	48
#define BOOTP_X_WINDOW_DISPLAY_MANAGERS	49
#define BOOTP_NIS_PLUS_DOMAIN		64
#define BOOTP_NIS_PLUS_SERVERS		65
#define BOOTP_MOBILE_IP_HOME_AGENTS	68
#define BOOTP_SMTP_SERVERS		69
#define BOOTP_POP3_SERVERS		70
#define BOOTP_NNTP_SERVERS		71
#define BOOTP_WWW_SERVERS		72
#define BOOTP_FINGER_SERVERS		73
#define BOOTP_IRC_SERVERS		74
#define BOOTP_STREETTALK_SERVERS	75

#define DHCP_REQUESTED_IP_ADDRESS	50
#define DHCP_LEASE_TIME			51
#define DHCP_OPTION_OVERLOAD		52
#define  DHCP_OPTION_OVERLOAD_FILE		1
#define  DHCP_OPTION_OVERLOAD_SNAME		2
#define  DHCP_OPTION_OVERLOAD_FILE_SNAME	3
#define DHCP_MESSAGE_TYPE		53
#define  DHCP_MESSAGE_TYPE_DISCOVER		1
#define  DHCP_MESSAGE_TYPE_OFFER		2
#define  DHCP_MESSAGE_TYPE_REQUEST		3
#define  DHCP_MESSAGE_TYPE_DECLINE		4
#define  DHCP_MESSAGE_TYPE_ACK			5
#define  DHCP_MESSAGE_TYPE_NAK			6
#define  DHCP_MESSAGE_TYPE_RELEASE		7
#define  DHCP_MESSAGE_TYPE_INFORM		8
#define DHCP_SERVER_IDENTIFIER		54
#define DHCP_PARAMETER_REQUEST_LIST	55
#define DHCP_MESSAGE			56
#define DHCP_MAXIMUM_SIZE		57
#define DHCP_RENEWAL_TIME		58
#define DHCP_REBINDING_TIME		59
#define DHCP_VENDOR_CLASS_ID		60
#define DHCP_CLIENT_ID			61

#define DHCP_TFTP_SERVER_NAME		66
#define DHCP_BOOTFILE_NAME		67

struct dhcp {
	/* IP */
	__u8 ip_vhl;		/* IP_VHL */
	__u8 ip_tos;		/* IPTOS_RELIABILITY */
	__u16 ip_len;
	__u16 ip_id;
	__u16 ip_off;		/* IP_DF */
	__u8 ip_ttl;		/* DHCP_TTL */
	__u8 ip_p;		/* IPPROTO_UDP */
	__u16 ip_sum;
	struct in_addr ip_src;
	struct in_addr ip_dst;
	/* UDP */
	__u16 udp_sport;	/* BOOTP_CLIENT_PORT */
	__u16 udp_dport;	/* BOOTP_SERVER_PORT */
	__u16 udp_len;
	__u16 udp_checksum;
	/* BOOTP */
	__u8 op;
	__u8 hwtype;
	__u8 hlen;
	__u8 hops;
	__u32 xid;
	__u16 secs;
	__u16 flags;
	__u32 ciaddr;
	__u32 yiaddr;
	__u32 siaddr;
	__u32 giaddr;
	__u8 chaddr[16];
	__u8 sname[64];
	__u8 file[128];
	__u8 options[64];	/* may be extended */
};

#define OP_BOOTREQUEST	0x01
#define OP_BOOTREPLY	0x02

#define DHCP_FLAG_BROADCAST	0x0001

#define BOOTP_OPTIONS_MAGIC	0x63825363

int dhcp_option(int domain, int option, char *buf, size_t size);

#endif
