#ifndef __SCSI_SCSI_H
#define __SCSI_SCSI_H

#include <SPAD/SCSI.H>

#define GOOD			(SCSI_GOOD >> 1)
#define CHECK_CONDITION		(SCSI_CHECK_CONDITION >> 1)
#define CONDITION_GOOD		(SCSI_CONDITION_MET >> 1)
#define BUSY			(SCSI_BUSY >> 1)
#define INTERMEDIATE_GOOD	(SCSI_INTERMEDIATE >> 1)
#define INTERMEDIATE_C_GOOD	(SCSI_INTERMEDIATE_CONDITION_MET >> 1)
#define RESERVATION_CONFLICT	(SCSI_RESERVATION_CONFLICT >> 1)
#define COMMAND_TERMINATED	(SCSI_COMMAND_TERMINATED >> 1)
#define QUEUE_FULL		(SCSI_QUEUE_FULL >> 1)
#define ACA_ACTIVE		(SCSI_ACA_ACTIVE >> 1)
#define TASK_ABORTED		(SCSI_TASK_ABORTED >> 1)

#define STATUS_MASK		0xfe

#define NO_SENSE		SCSI_KEY_NO_SENSE
#define RECOVERED_ERROR		SCSI_KEY_RECOVERED_ERROR
#define NOT_READY		SCSI_KEY_NOT_READY
#define MEDIUM_ERROR		SCSI_KEY_MEDIUM_ERROR
#define HARDWARE_ERROR		SCSI_KEY_HARDWARE_ERROR
#define ILLEGAL_REQUEST		SCSI_KEY_ILLEGAL_REQUEST
#define UNIT_ATTENTION		SCSI_KEY_UNIT_ATTENTION
#define DATA_PROTECT		SCSI_KEY_DATA_PROTECT
#define BLANK_CHECK		SCSI_KEY_BLANK_CHECK
#define COPY_ABORTED		SCSI_KEY_COPY_ABORTED
#define ABORTED_COMMAND		SCSI_KEY_ABORTED_COMMAND
#define VOLUME_OVERFLOW		SCSI_KEY_VOLUME_OVERFLOW
#define MISCOMPARE		SCSI_KEY_MISCOMPARE

#define TYPE_DISK		SCSI_TYPE_DA
#define TYPE_TAPE		SCSI_TYPE_SA
#define TYPE_PRINTER		SCSI_TYPE_PRINTER
#define TYPE_PROCESSOR		SCSI_TYPE_PROCESSOR
#define TYPE_WORM		SCSI_TYPE_WORM
#define TYPE_ROM		SCSI_TYPE_CD_DVD
#define TYPE_SCANNER		SCSI_TYPE_SCANNER
#define TYPE_MOD		SCSI_TYPE_OPTICAL_DA
#define TYPE_MEDIUM_CHANGER	SCSI_TYPE_JUKEBOX
#define TYPE_COMM		SCSI_TYPE_COMMUNICATIONS
#define TYPE_RAID		SCSI_TYPE_RAID
#define TYPE_ENCLOSURE		SCSI_TYPE_ENCLOSURE
#define TYPE_RBC		SCSI_TYPE_REDUCED_DA
#define TYPE_NO_LUN		0x7f

#define DID_OK		0x00
#define DID_NO_CONNECT	0x01
#define DID_BUS_BUSY	0x02
#define DID_TIME_OUT	0x03
#define DID_BAD_TARGET	0x04
#define DID_ABORT	0x05
#define DID_PARITY	0x06
#define DID_ERROR	0x07
#define DID_RESET	0x08
#define DID_BAD_INTR	0x09
#define DID_PASSTHROUGH	0x0a
#define DID_SOFT_ERROR	0x0b
#define DID_IMM_RETRY	0x0c
#define DID_REQUEUE	0x0d

#define DRIVER_OK	0x00
#define DRIVER_BUSY	0x01
#define DRIVER_SOFT	0x02
#define DRIVER_MEDIA	0x03
#define DRIVER_ERROR	0x04

#define DRIVER_INVALID	0x05
#define DRIVER_TIMEOUT	0x06
#define DRIVER_HARD	0x07
#define DRIVER_SENSE	0x08

#define SUGGEST_RETRY	0x10
#define SUGGEST_ABORT	0x20
#define SUGGEST_REMAP	0x30
#define SUGGEST_DIE	0x40
#define SUGGEST_SENSE	0x80
#define SUGGEST_IS_OK	0xff

#define DRIVER_MASK	0x0f
#define SUGGEST_MASK	0xf0

#endif
