#ifndef __SCSI_SG_H
#define __SCSI_SG_H

typedef struct sg_iovec {
	void *iov_base;
	size_t iov_len;
} sg_iovec_t;

typedef struct sg_io_hdr {
	int interface_id;	/* [i] 'S' for SCSI generic (required) */
	int dxfer_direction;	/* [i] data transfer direction */
#define SG_DXFER_NONE		(-1)
#define SG_DXFER_TO_DEV		(-2)
#define SG_DXFER_FROM_DEV	(-3)
#define SG_DXFER_TO_FROM_DEV	(-4)
#define SG_DXFER_UNKNOWN	(-5)
	unsigned char cmd_len;	/* [i] SCSI command length ( <= 16 bytes) */
	unsigned char mx_sb_len;/* [i] max length to write to sbp */
	unsigned short iovec_count;/* [i] 0 implies no scatter gather */
	unsigned dxfer_len;	/* [i] byte count of data transfer */
	void *dxferp;		/* [i], [*io] points to data transfer memory
					or scatter gather list */
	unsigned char *cmdp;	/* [i], [*i] points to command to perform */
	void *sbp;		/* [i], [*o] points to sense_buffer memory */
	unsigned timeout;	/* [i] MAX_UINT->no timeout (unit: millisec) */
	unsigned flags;		/* [i] 0 -> default, see SG_FLAG... */
#define SG_FLAG_DIRECT_IO		0x01
#define SG_FLAG_UNUSED_LUN_INHIBIT	0x02
#define SG_FLAG_MMAP_IO			0x04
	unsigned char status;	/* [o] scsi status */
	unsigned char masked_status; /* [o] shifted, masked scsi status */
	unsigned char msg_status;/* [o] messaging level data (optional) */
	unsigned char sb_len_wr;/* [o] byte count actually written to sbp */
	unsigned short host_status;/* [o] errors from host adapter */
	unsigned short driver_status;/* [o] errors from software driver */
	int resid;		/* [o] dxfer_len - actual_transferred */
	unsigned int duration;	/* [o] time taken by cmd (unit: millisec) */
	unsigned int info;	/* [o] auxiliary information */
	int pack_id;		/* unused */
	void *usr_ptr;		/* unused */
} sg_io_hdr_t;

#define SG_INTERFACE_ID_ORIG	'S'

/* Old interface. Not supported, only to make apps compile */

#define SG_MAX_SENSE	16

struct sg_header {
	int pack_len;
	int reply_len;
	int pack_id;
	int result;
	unsigned twelve_byte:1;
	unsigned target_status:5;
	unsigned host_status:8;
	unsigned driver_status:8;
	unsigned other_flags:10;
	unsigned char sense_buffer[SG_MAX_SENSE];
};

#endif
