#ifndef __SEMAPHORE_H
#define __SEMAPHORE_H

#include <SYS/TYPES.H>
#include <TIME.H>

typedef struct __sem_t *sem_t;

__BEGIN_DECLS
int sem_init(sem_t *sem, int pshared, unsigned value);
int sem_destroy(sem_t *sem);
int sem_getvalue(sem_t *sem, int *sval);
int sem_post(sem_t *sem);
int sem_wait(sem_t *sem);
int sem_trywait(sem_t *sem);
int sem_timedwait(sem_t *sem, const struct timespec *abs_timeout);
__END_DECLS

#endif
