#ifndef __SPAD_AC_H
#define __SPAD_AC_H

#include <ARCH/AC.H>
#include <ARCH/BITOPS.H>
#include <SYS/TYPES.H>
#include <SPAD/LIBC.H>

__BEGIN_DECLS

void KERNEL$CIO(IORQ *RQ);

extern IO_STUB KERNEL$SUCCESS;
extern AST_STUB KERNEL$AST_FREE;

__END_DECLS

#define GET_STRUCT(PTR, TYPE, MEMBER) ((TYPE*)(void *)((char*)(PTR)-(unsigned long)(&((TYPE*)0)->MEMBER)))

#define IO_ENABLE_CANCEL(splx, io, stub)				\
do {									\
	if (__DEBUG >= 2 && __unlikely(KERNEL$SPL != splx))		\
		KERNEL$SUICIDE("IO_ENABLE_CANCEL AT SPL %08X, EXPECTED %08X", KERNEL$SPL, splx);							\
	RAISE_SPL(SPL_TOP);						\
	(io)->tmp1 = (unsigned long)stub;				\
	if (__unlikely((io)->status == RQS_WANTCANCEL)) {		\
		(io)->status = RQS_CANCELING;				\
		LOWER_SPLX(splx);					\
		CALL_IORQ_LSTAT_EXPR(io, stub);				\
	} else {							\
		(io)->status = RQS_CANCELABLE;				\
		LOWER_SPLX(splx);					\
	}								\
} while (0)

#define IO_DISABLE_CANCEL(splx, io, cancel_in_progress)			\
{									\
	if (__DEBUG >= 2 && __unlikely(KERNEL$SPL != splx))		\
		KERNEL$SUICIDE("IO_DISABLE_CANCEL AT SPL %08X, EXPECTED %08X", KERNEL$SPL, splx);							\
	RAISE_SPL(SPL_TOP);						\
	if (__unlikely((io)->status == RQS_CANCELING)) {		\
		LOWER_SPLX(splx);					\
		cancel_in_progress;					\
	}								\
	(io)->status = RQS_PROCESSING;					\
	LOWER_SPLX(splx);						\
}

#define IO_DISABLE_CHAIN_CANCEL(splx, io)				\
do {									\
	if (__DEBUG >= 2 && __unlikely(KERNEL$SPL != splx))		\
		KERNEL$SUICIDE("IO_DISABLE_CHAIN_CANCEL AT SPL %08X, EXPECTED %08X", KERNEL$SPL, splx);							\
	__CMPXCHGL(&(io)->status, RQS_CHAINCANCELABLE, RQS_PROCESSING);	\
} while (0)

#define IO_ENABLE_KERNEL_CANCEL(io, cancel_in_progress)			\
{									\
	int __st;							\
	again:								\
	if (__likely(((__st = (io)->status) & RQS_ACTION_MASK) == RQS_PROCESSING)) { 									\
		if (__unlikely(__CMPXCHGL(&(io)->status, __st, RQS_KERNELCANCELABLE) != 0)) goto again; 						\
	} else {							\
		__ORL(&(io)->status, 0); /* probe write access */	\
		if (__unlikely(__st == RQS_WANTCANCEL)) {		\
			(io)->status = -EINTR;				\
			CALL_AST(io);					\
			cancel_in_progress;				\
		}							\
	}								\
}

#endif
