#ifndef __SPAD_ALLOC_H
#define __SPAD_ALLOC_H

#include <SYS/TYPES.H>
#include <SPAD/AC.H>
#include <SPAD/WQ.H>
#include <SPAD/VMDEF.H>

__BEGIN_DECLS

#define AREA_CODE		0x00000001
#define AREA_DATA		0x00000002
#define AREA_ISADMA		0x00000004
#define AREA_PCIDMA		0x00000008
#define AREA_PCIDMA64		0x00000010

#define AREA_PHYSCONTIG		0x00010000
#define AREA_ALIGN		0x00020000
#define AREA_NODE		0x00040000

void *KERNEL$ALLOC_CONTIG_AREA(unsigned long size, int flags, ...);
void KERNEL$FREE_CONTIG_AREA(void *ptr, unsigned long size);



typedef struct {
	IORQ_HEAD;
	void *ptr;
	size_t size;
} MALLOC_REQUEST;

extern IO_STUB KERNEL$UNIVERSAL_MALLOC;

/* when KERNEL$OOM != 0, do not sleep at KERNEL$FREEMEM_WAIT, and return
   allocation error directly ... you won't probably get any memory at all,
   because kernel is out of memory ...
   when KERNEL$OOM != 0, you may sleep at KERNEL$FREEMEM_WAIT only if you
   cannot (because of some critical reason, I can't think of any now)
   return allocation error. If your memory request has critical priority, you
   can sleep on KERNEL$OOM and expect that *MAYBE* someone will free some memory
   after some time.
   DO NOT sleep on KERNEL$FREEMEM_WAIT if your driver may be needed to free
   some memory (i.e. block device, filesystem, net device, net protocol that
   filesystems may run on)
*/

extern WQ KERNEL$FREEMEM_WAIT;
int KERNEL$OOM(int type);
int KERNEL$OOM_ERR(size_t size);

extern IO_STUB KERNEL$WAIT_ON_FREEMEM;

void KERNEL$MEMWAIT(IORQ *rq, IO_STUB *fn, size_t sz);
int KERNEL$MEMWAIT_SYNC(size_t sz);

__END_DECLS

#endif
