#ifndef __SPAD_ATA_H
#define __SPAD_ATA_H

#include <SYS/TYPES.H>
#include <SPAD/BIO.H>
#include <SPAD/TIMER.H>

#include <SPAD/SCSI.H>

typedef struct __aport APORT;

typedef struct __atafiscmd ATAFISCMD;
typedef struct __atarq ATARQ;
typedef struct __ata_attach_param ATA_ATTACH_PARAM;

struct __atafiscmd {
	/* This corresponds with the part of SATA FIS */
	__u8 command;
	__u8 feature0;
	__u8 lba0;		/* also sector */
	__u8 lba8;		/* also cyl_l */
	__u8 lba16;		/* cyl_h */
	__u8 device;		/* head & 0xf */
	__u8 lba24;
	__u8 lba32;
	__u8 lba40;
	__u8 feature8;
	__u8 nsect0;
	__u8 nsect8;
	__u8 pad;
	__u8 ctl;
};

struct __atarq {
	APORT *port;
	void (*done)(ATARQ *);
	int status;
	__u8 device;
	__u8 retries;
	unsigned short atarq_flags;
	ATAFISCMD fis;
	__u8 multicount;	/* for PIO transfers */
	BIODESC *desc;
	unsigned len;
	u_jiffies_lo_t timeout;
	BIORQ *brq;	/* associated BIORQ for adapter-level scheduling */
			/* or NULL if not initiated from BIORQ */
};

#define ATA_PROTOCOL_NODATA	0
#define ATA_PROTOCOL_PIO	1
#define ATA_PROTOCOL_DMA	4	/* this is also used as a flag */
#define ATA_PROTOCOL_TCQ	5	/* unused */
#define ATA_PROTOCOL_NCQ	6	/* unused */

#define ATARQ_PROTOCOL		0x0007
#define ATARQ_TO_DEVICE		0x0008	/* must be equal to DMACMD_READ */
#define ATARQ_VALID_48BIT	0x0010
#define ATARQ_VALID_FEATURE	0x0020
#define ATARQ_SET_SIZE		0x0040
#define ATARQ_RETRIED		0x0080	/* set by the host controller */
#define ATARQ_ERROR_ALLOW_ABORT	0x0100

struct __ata_attach_param {
	/* ad -> host adapter */
	unsigned version;
	u_jiffies_lo_t probe_timeout;
	char *msg;	/* exception: host adapter -> ad */
	__const__ char *param;
	__const__ char *dev_prefix;

	char (*dev_name)[__MAX_STR_LEN]; /* ad sets it, host fills it */
	/* host adapter -> ad (ad should zero these on 1st attempt) */
	int (*aux_cmd)(ATA_ATTACH_PARAM *ap, int cmd, ...);
	APORT *port;
	__u8 device;
	__u8 queue_depth;
	short biosched; /* exception: ad -> host adapter */
	int (*post)(ATARQ *);

	/* ad -> host adapter */
	int (*dequeue)(ATA_ATTACH_PARAM *);
	BIORQ *(*probe_queue)(ATA_ATTACH_PARAM *);
};

#define ATA_VERSION		(1 | (sizeof(ATARQ) << 16) | (sizeof(ATA_ATTACH_PARAM) << 24))

#define ATA_CMD_GET		0
#define ATA_CMD_FREE		1

#define ATA_AUX_GET_PROTOCOL_MASK	1	/* __u16 *id, unsigned mask */
#define ATA_AUX_SETUP_PIO_XFER		2	/* __u16 *id, unsigned mask, jiffies_lo_t timeout */
#define ATA_AUX_SETUP_DMA_XFER		3	/* __u16 *id, unsigned mask, jiffies_lo_t timeout */
#define ATA_AUX_FIXUP_IDENT		4	/* __u16 *id */
#define ATA_AUX_GET_TRANSFER_SIZE	5	/* int dma */
#define ATA_AUX_SET_ATAPI_FLAGS		6	/* unsigned flags */
#define		ATA_AUX_ATAPI_FLAGS_PROTOCOL	0x07
#define		ATA_AUX_ATAPI_FLAGS_DMADIR	0x08
#define		ATA_AUX_ATAPI_FLAGS_DRQ_INT	0x10
#define		ATA_AUX_ATAPI_FLAGS_LONG_DRQ	0x20
#define		ATA_AUX_ATAPI_FLAGS_CMD_16	0x40

#define ATAPI_DRQ_SHORT	((JIFFIES_PER_SECOND + 19999) / 20000)	/* 50us */
#define ATAPI_DRQ_LONG	((JIFFIES_PER_SECOND + 332) / 333)	/* 3ms */


#define	ATA_ERROR_NM			0x02
#define	ATA_ERROR_ABORT			0x04
#define	ATA_ERROR_MCR			0x08
#define	ATA_ERROR_IDNF			0x10
#define	ATA_ERROR_MC			0x20
#define	ATA_ERROR_UNC			0x40
#define	ATA_ERROR_ICRC			0x80		/* UDMA only */

#define	ATA_ERROR_ILI			0x01 /* these are for packet */
#define	ATA_ERROR_EOM			0x02
#define	ATA_ERROR_ABORT			0x04
#define	ATA_ERROR_SENSE_KEY		0xf0

#define	ATA_QSTAT_CD			0x01	/* for TCQ */
#define	ATA_QSTAT_IO			0x02
#define	ATA_QSTAT_REL			0x04
#define	ATA_QSTAT_TAG			0xf8

#define	ATA_DEVICE_DRIVE		0x10
#define	ATA_DEVICE_LBA			0x40
#define	ATA_DEVICE_ATAPI_OR_BITS	0xA0

#define	ATA_STATUS_ERROR		0x01
#define	ATA_STATUS_DRQ			0x08
#define	ATA_STATUS_SERV			0x10
#define	ATA_STATUS_DF			0x20
#define	ATA_STATUS_DRDY			0x40
#define	ATA_STATUS_BSY			0x80

#define	ATA_CTRL_NIEN			0x02
#define	ATA_CTRL_SRST			0x04
#define	ATA_CTRL_ONE			0x08
#define	ATA_CTRL_HOB			0x80

#define	ATA_CMD_NOP				0x00
#define		ATA_FEATURE_NOP_NOP				0x00
#define		ATA_FEATURE_NOP_AUTO_POLL			0x01
#define ATA_CMD_DEVICE_RESET			0x08
#define	ATA_CMD_READ				0x20
#define	ATA_CMD_READ_EXT			0x24
#define	ATA_CMD_READ_DMA_EXT			0x25
#define	ATA_CMD_READ_DMA_QUEUED_EXT		0x26
#define	ATA_CMD_READ_NATIVE_MAX_ADDRESS_EXT	0x27
#define	ATA_CMD_READ_MULTIPLE_EXT		0x29
#define	ATA_CMD_WRITE				0x30
#define	ATA_CMD_WRITE_EXT			0x34
#define	ATA_CMD_WRITE_DMA_EXT			0x35
#define	ATA_CMD_WRITE_DMA_QUEUED_EXT		0x36
#define	ATA_CMD_SET_MAX_ADDRESS_EXT		0x37
#define	ATA_CMD_WRITE_MULTIPLE_EXT		0x39
#define	ATA_CMD_WRITE_DMA_FUA_EXT		0x3d
#define	ATA_CMD_WRITE_DMA_QUEUED_FUA_EXT	0x3e
#define	ATA_CMD_PACKET				0xa0
#define		ATA_FEATURE_PACKET_DMA				0x01
#define		ATA_FEATURE_PACKET_OVL				0x02
#define		ATA_FEATURE_PACKET_DMADIR			0x04
#define	ATA_CMD_IDENTIFY_PACKET_DEVICE		0xa1
#define	ATA_CMD_SERVICE				0xa2
#define	ATA_CMD_CONFIGURATION			0xb1
#define		ATA_FEATURE_CONFIGURATION_RESTORE		0xc0
#define		ATA_FEATURE_CONFIGURATION_FREEZE_LOCK		0xc1
#define		ATA_FEATURE_CONFIGURATION_IDENTIFY		0xc2
#define		ATA_FEATURE_CONFIGURATION_SET			0xc3
#define	ATA_CMD_READ_MULTIPLE			0xc4
#define	ATA_CMD_WRITE_MULTIPLE			0xc5
#define	ATA_CMD_SET_MULTIPLE_MODE		0xc6
#define	ATA_CMD_READ_DMA_QUEUED			0xc7
#define	ATA_CMD_READ_DMA			0xc8
#define	ATA_CMD_WRITE_DMA			0xca
#define	ATA_CMD_WRITE_DMA_QUEUED		0xcc
#define	ATA_CMD_WRITE_MULTIPLE_FUA_EXT		0xce
#define	ATA_CMD_FLUSH_CACHE			0xe7
#define	ATA_CMD_FLUSH_CACHE_EXT			0xea
#define	ATA_CMD_IDENTIFY_DEVICE			0xec
#define	ATA_CMD_SET_FEATURES			0xef
#define		ATA_FEATURE_SET_FEATURES_ENABLE_WCACHE		0x02
#define		ATA_FEATURE_SET_FEATURES_XFER			0x03
#define			ATA_SET_XFER_DEFAULT_PIO		0x00
#define			ATA_SET_XFER_DEFAULT_PIO_NO_IORDY	0x01
#define			ATA_SET_XFER_PIO			0x08
#define			ATA_SET_XFER_SDMA			0x10
#define			ATA_SET_XFER_WDMA			0x20
#define			ATA_SET_XFER_UDMA			0x40
#define		ATA_FEATURE_SET_FEATURES_SPIN_UP		0x07
#define		ATA_FEATURE_SET_FEATURES_DISABLE_RCACHE		0x55
#define		ATA_FEATURE_SET_FEATURES_ENABLE_REL_INT		0x5d
#define		ATA_FEATURE_SET_FEATURES_ENABLE_SERV_INT	0x5e
#define		ATA_FEATURE_SET_FEATURES_DISABLE_WCACHE		0x82
#define		ATA_FEATURE_SET_FEATURES_ENABLE_RCACHE		0xaa
#define		ATA_FEATURE_SET_FEATURES_DISABLE_REL_INT	0xdd
#define		ATA_FEATURE_SET_FEATURES_DISABLE_SERV_INT	0xde
#define	ATA_CMD_READ_NATIVE_MAX_ADDRESS		0xf8
#define	ATA_CMD_SET_MAX_ADDRESS			0xf9

#define IDE_XFER_PIO_0		0x00000001
#define IDE_XFER_PIO_1		0x00000002
#define IDE_XFER_PIO_2		0x00000004
#define IDE_XFER_PIO_3		0x00000008
#define IDE_XFER_PIO_4		0x00000010
#define IDE_XFER_PIO_5		0x00000020
#define IDE_XFER_PIO_6		0x00000040
#define IDE_XFER_SDMA_0		0x00000100
#define IDE_XFER_SDMA_1		0x00000200
#define IDE_XFER_SDMA_2		0x00000400
#define IDE_XFER_WDMA_0		0x00000800
#define IDE_XFER_WDMA_1		0x00001000
#define IDE_XFER_WDMA_2		0x00002000
#define IDE_XFER_WDMA_3		0x00004000
#define IDE_XFER_WDMA_4		0x00008000
#define IDE_XFER_UDMA_0		0x00010000
#define IDE_XFER_UDMA_1		0x00020000
#define IDE_XFER_UDMA_2		0x00040000
#define IDE_XFER_UDMA_3		0x00080000
#define IDE_XFER_UDMA_4		0x00100000
#define IDE_XFER_UDMA_5		0x00200000
#define IDE_XFER_UDMA_6		0x00400000
#define IDE_XFER_PIO_NONE	0x40000000
#define IDE_XFER_DMA_NONE	0x80000000
#define IDE_XFER_MASK_PIO	(IDE_XFER_PIO_0 | IDE_XFER_PIO_1 | IDE_XFER_PIO_2 | IDE_XFER_PIO_3 | IDE_XFER_PIO_4 | IDE_XFER_PIO_5 | IDE_XFER_PIO_6 | IDE_XFER_PIO_NONE)
#define IDE_XFER_MASK_SDMA	(IDE_XFER_SDMA_0 | IDE_XFER_SDMA_1 | IDE_XFER_SDMA_2)
#define IDE_XFER_MASK_WDMA	(IDE_XFER_WDMA_0 | IDE_XFER_WDMA_1 | IDE_XFER_WDMA_2 | IDE_XFER_WDMA_3 | IDE_XFER_WDMA_4)
#define IDE_XFER_MASK_UDMA	(IDE_XFER_UDMA_0 | IDE_XFER_UDMA_1 | IDE_XFER_UDMA_2 | IDE_XFER_UDMA_3 | IDE_XFER_UDMA_4 | IDE_XFER_UDMA_5 | IDE_XFER_UDMA_6)
#define IDE_XFER_MASK_DMA	(IDE_XFER_MASK_SDMA | IDE_XFER_MASK_WDMA | IDE_XFER_MASK_UDMA | IDE_XFER_DMA_NONE)
#define IDE_XFER_MASK		(IDE_XFER_MASK_PIO | IDE_XFER_MASK_DMA)

#define N_PIO_MODES		8	/* 1 is reserved */
#define N_SDMA_MODES		3
#define N_WDMA_MODES		5
#define N_UDMA_MODES		7
#define N_DMA_MODES		(N_SDMA_MODES + N_WDMA_MODES + N_UDMA_MODES)

void ATA$SYNC_RQ(ATARQ *rq, ATA_ATTACH_PARAM *ap, void *ptr, unsigned long len, u_jiffies_lo_t timeout, int retries);

typedef struct __asglist ASGLIST;

ASGLIST *ATA$ALLOC_SGLIST(const char *dev_name, __u32 *dev_addr);
void ATA$FREE_SGLIST(const char *dev_name, ASGLIST *sg);
int ATA$SGLIST_RECOMMENDED_SIZE(ASGLIST *sg, int dma);
int ATA$SGLIST_GUARANTEED_SIZE(ASGLIST *sg, int dma);
int ATA$MAP_DMA(ASGLIST *sg, BIODESC **pdesc, unsigned plen, int rw, int preserve);
void ATA$UNMAP_DMA(ASGLIST *sg);
int ATA$MAP_PIO(ASGLIST *sg, BIODESC **pdesc, unsigned plen, int rw, int preserve);
void ATA$UNMAP_PIO(ASGLIST *sg);
void *ATA$MAP_PIO_SECTOR(ASGLIST *sg, unsigned pos);
void ATA$SET_NEXT_PIO_SECTOR(ASGLIST *sg, unsigned *pos);
void ATA$UNMAP_PIO_SECTOR(ASGLIST *sg, void *data);

const char *ATA$COMMAND_NAME(__u8 cmd, __u8 feature);
int ATA$DUMMY_DEQUEUE(ATA_ATTACH_PARAM *ap);
BIORQ *ATA$DUMMY_PROBE_QUEUE(ATA_ATTACH_PARAM *ap);
int ATA$IS_ATAPI(__const__ __u16 ident[256]);
void ATA$BSWAP_IDENTIFY(__u16 id[256]);
void ATA$GET_MODEL(__const__ __u16 id[256], char (*model)[41], char (*serial)[21], char (*revision)[9]);
unsigned ATA$XFER_BEST(unsigned mask);
unsigned ATA$GET_XFER_MODE(__const__ __u16 id[256]);
int ATA$SETUP_XFER(ATA_ATTACH_PARAM *ap, int dma, __const__ __u16 id[256], unsigned users_xfer, unsigned drive_xfer_mask, unsigned controller_xfer_mask, unsigned controller_xfer_mask_unsupported, int (*set)(APORT *p, int drive, unsigned pio, __const__ __u16 id[256]), u_jiffies_lo_t timeout);
int ATA$SET_XFER_EMPTY(APORT *p, int drive, unsigned pio, __const__ __u16 id[256]);
void ATA$CABLE40_RESTRICT(unsigned *controller_xfer_mask, unsigned *controller_xfer_mask_unsupported);
void ATA$CHECK_DEVICE_CABLE(__const__ __u16 ident[256], unsigned *controller_xfer_mask, unsigned *controller_xfer_mask_unsupported);

struct ata_timing {
	unsigned short setup;
	unsigned short act8b;
	unsigned short rec8b;
	unsigned short cyc8b;
	unsigned short active;
	unsigned short recover;
	unsigned short cycle;
	unsigned short udma;
};

void ATA$INIT_TIMING(struct ata_timing *t);
void ATA$MERGE_PIO_TIMING(struct ata_timing *t, unsigned pio, unsigned what);
void ATA$MERGE_DMA_TIMING(struct ata_timing *t, unsigned dma, unsigned what);
void ATA$MERGE_TIMING(struct ata_timing *t, __const__ struct ata_timing *m, unsigned what);
void ATA$QUANTIZE_TIMING(struct ata_timing *t, unsigned bus, unsigned udma_bus) ;
unsigned ATA$FIT_TIMING(unsigned val, unsigned min, unsigned max, unsigned sub);

#define ATA_MERGE_SETUP		0x01
#define ATA_MERGE_ACT8B		0x02
#define ATA_MERGE_REC8B		0x04
#define ATA_MERGE_CYC8B		0x08
#define ATA_MERGE_ACTIVE	0x10
#define ATA_MERGE_RECOVER	0x20
#define ATA_MERGE_CYCLE		0x40
#define ATA_MERGE_UDMA		0x80

#define ATA_MERGE_8BIT		(ATA_MERGE_ACT8B | ATA_MERGE_REC8B | ATA_MERGE_CYC8B)
#define ATA_MERGE_ALL		0xff

unsigned ATA$XFER_GET_NUMBER(unsigned val, unsigned mask);

unsigned ATA$BLACKLIST_SEARCH(const char * const blacklist[], const __u16 ident[256]);
void ATA$BLACKLIST_RESTRICT(const char * const blacklist[], const __u16 ident[256], unsigned mask, unsigned *avail, unsigned *avail_unsupported);

int ATA$PI_ATTACH(void *a, __DCALL *dc, SCSI_ATTACH_PARAM *sa, int ports, int devices);
void ATA$PI_DETACH(void *a, __DCALL *dc, SCSI_ATTACH_PARAM *sa);
int ATA$PI_SCSI_DCALL(int cmd, va_list params);
u_jiffies_lo_t ATA$PI_TIMEOUT(ATA_ATTACH_PARAM *ap);
void ATA$PI_PATCH_COMMAND(SCSIRQ *rq);

#endif
