#ifndef __SPAD_CHARSET_H
#define __SPAD_CHARSET_H

#include <SYS/TYPES.H>
#include <ICONV.H>

__BEGIN_DECLS

typedef struct __charset_8b CHARSET_8B;

CHARSET_8B *CHARSET$OPEN_8B(__const__ char *name);
void CHARSET$CLOSE_8B(CHARSET_8B *conv, int keep);
__s32 CHARSET$8B2UNI(CHARSET_8B *conv, unsigned char chr);
int CHARSET$UNI28B(CHARSET_8B *conv, __s32 uni);

typedef struct __fallback FALLBACK;

FALLBACK *CHARSET$OPEN_FALLBACK(__const__ char *filename);
void CHARSET$CLOSE_FALLBACK(FALLBACK *fb, int keep);
__s32 *CHARSET$GET_FALLBACK(FALLBACK *fb, __s32 uni, unsigned order);

int CHARSET$UNI28B_FALLBACK(CHARSET_8B *to, FALLBACK *fb, __s32 uni);
int CHARSET$8B28B_FALLBACK(CHARSET_8B *from, CHARSET_8B *to, FALLBACK *fb, unsigned char chr);

char *CHARSET$RESOLVE_ALIAS(__const__ char *name);

#define ICONV_ATTR_IGNORE_INVALID_INPUT		1
#define ICONV_ATTR_NO_FALLBACK			2
#define ICONV_ATTR_IGNORE_IMPOSSIBLE_OUTPUT	4
#define ICONV_ATTR_DELAYED_LOADING		8
#define ICONV_ATTR_PASS_CONTROL			16
#define ICONV_ATTR_LEAVE_AT_UNLOAD		256	/* must be >= 256, shoult not be used outside libc */
iconv_t CHARSET$ICONV_OPEN(__const__ char *to, __const__ char *from, int flags);
void CHARSET$ICONV_CLOSE(iconv_t ic);
size_t CHARSET$ICONV(iconv_t ic, char **inbuf, size_t *inlen, char **outbuf, size_t *outlen);

void CHARSET$LIST_8B(void (*process)(const char *name, void *cookie), void *cookie);
void CHARSET$LIST_SPECIAL(void (*process)(const char *name, void *cookie), void *cookie);
void CHARSET$LIST_ALIASES(const char *name, void (*process)(const char *name, void *cookie), void *cookie);

__END_DECLS

#endif
