#ifndef __SPAD_ETHERNET_H
#define __SPAD_ETHERNET_H

#include <SPAD/PKT.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

#define ETHERNET_ADDRLEN	6

struct eth_header {
	__u8 dst[ETHERNET_ADDRLEN];
	__u8 src[ETHERNET_ADDRLEN];
	__u16 typelen;
};

#define ETH_HEADER(p)	((struct eth_header *)(void *)((p)->data + LL_HEADER - sizeof(struct eth_header)))

int NET$PARSE_ETHERNET_ADDRESS(__const__ char *str, __u8 address[6]);
int NET$VALID_ETHERNET_ADDRESS(__u8 address[6]);
#define ETHERNET_ADDRESS_STR_LEN	18
char *NET$PRINT_ETHERNET_ADDRESS(char str[ETHERNET_ADDRESS_STR_LEN], __u8 address[6]);
#define ETHERNET_ZLEN		60
#define ETHERNET_MTU		1500
#define ETHERNET_JUMBO_MTU	9000
#define ETHERNET_HEADER		((unsigned)sizeof(struct eth_header))

#define ETHERNET_FILL_IF_TYPE(t)				\
do {								\
	(t)->addrlen = ETHERNET_ADDRLEN;			\
	(t)->arptype = htons(1);				\
	strlcpy((t)->type, "ETHERNET", sizeof((t)->type));	\
	(t)->mtu = ETHERNET_MTU;				\
} while (0)

__u32 NET$BITREVERSE32(__u32 x);
__u32 NET$CRC32_LE(__u32 crc, __const__ __u8 *data, unsigned len);
__u32 NET$ETHERNET_CRC_LE(__const__ __u8 *data, unsigned len);
__u32 NET$ETHERNET_CRC(__const__ __u8 *data, unsigned len);

__END_DECLS

#endif
