#ifndef __SPAD_IOC_H
#define __SPAD_IOC_H

#include <STDARG.H>

#include <SPAD/DEV.H>
#include <SPAD/SYNC.H>
#include <ERRNO.H>

typedef int ioc_fn(int, unsigned long, va_list);
typedef const char *translate_unx_fn(const char *str, const char **to_free);

struct ioc_entry {
	unsigned long ioctl;
	unsigned long n;
	ioc_fn *fn;
};

#ifdef IOC_USE_TTY
#define _IOC_PARAM_TTY	, int _IOC_TTY
#define _IOC_PASS_TTY	, _IOC_TTY
#else
#define _IOC_PARAM_TTY
#define _IOC_PASS_TTY
#define _IOC_TTY	0
#define raise_sighup()
#endif

#define IOC_GEN_GET_MODE						\
static int get_mode_data(int h, unsigned ioc, unsigned long param, void *data, unsigned long datalen _IOC_PARAM_TTY);					\
									\
static int get_mode(int h, unsigned ioc, unsigned long param _IOC_PARAM_TTY)\
{									\
	return get_mode_data(h, ioc, param, NULL, 0 _IOC_PASS_TTY);	\
}

#define IOC_GEN_GET_MODE_DATA						\
static int get_mode_data(int h, unsigned ioc, unsigned long param, void *data, unsigned long datalen _IOC_PARAM_TTY)					\
{									\
	IOCTLRQ io;							\
	io.h = h;							\
	io.ioctl = ioc;							\
	io.param = param;						\
	io.v.vspace = &KERNEL$VIRTUAL;					\
	io.v.ptr = (unsigned long)data;					\
	io.v.len = datalen;						\
	SYNC_IO(&io, KERNEL$IOCTL);					\
	if (__unlikely(io.status < 0)) {				\
		if (io.status == -ENOOP) io.status = _IOC_TTY ? -ENOTTY : -EINVAL;									\
		if (io.status == -ENOLNM && _IOC_TTY && (unsigned)io.h <= 2) {\
			raise_sighup();					\
			io.status = -EIO;				\
		}							\
		errno = -io.status;					\
		return -1;						\
	}								\
	return io.status;						\
}

#define IOC_GEN_SET_MODE_INT						\
static int set_mode_int(int h, char *str, int val _IOC_PARAM_TTY)	\
{									\
	char valstr[12];						\
	CHHRQ ch;							\
	if (__unlikely(_snprintf(valstr, sizeof(valstr), "%d", val) < 0)) {\
		errno = ERANGE;						\
		return -1;						\
	}								\
	ch.h = h;							\
	ch.option = str;						\
	ch.value = valstr;						\
	SYNC_IO(&ch, KERNEL$CHANGE_HANDLE);				\
	if (__unlikely(ch.status < 0)) {				\
		if (ch.status == -EBADMOD || ch.status == -ENOENT || ch.status == -ENOOP) ch.status = _IOC_TTY ? -ENOTTY : -EINVAL;			\
		if (ch.status == -ENOLNM && _IOC_TTY && (unsigned)ch.h <= 2) {\
			raise_sighup();					\
			ch.status = -EIO;				\
		}							\
		errno = -ch.status;					\
		return -1;						\
	}								\
	return 0;							\
}

#endif
