#ifndef __SPAD_IOCTL_H
#define __SPAD_IOCTL_H

#define IOCTL_TYPE_NODATA	0
#define IOCTL_TYPE_WRITE	1	/* must match PF_WRITE */
#define IOCTL_TYPE_READ		2	/* must match PF_READ */
#define IOCTL_TYPE_READWRITE	3	/* must match PF_RW */

#define IO_ND(x)	(((x) << 4) + IOCTL_TYPE_NODATA)
#define IO_WR(x)	(((x) << 4) + IOCTL_TYPE_WRITE)
#define IO_RD(x)	(((x) << 4) + IOCTL_TYPE_READ)
#define IO_RW(x)	(((x) << 4) + IOCTL_TYPE_READWRITE)

#define IO_TYPE(x)	((x) & 0xf)

#define IOCTL_NOP				IO_ND(0x000)
#define IOCTL_READDIR				IO_RW(0x001) /* vdesc points to struct readdir_buffer, it must be __PAGE_SIZE (not more); if it's smaller, the kernel might return -EMSGSIZE */
#define IOCTL_STAT				IO_WR(0x002)
#define IOCTL_STATFS				IO_WR(0x003)
#define IOCTL_LSEEK				IO_RW(0x004)
#define IOCTL_TRUNCATE				IO_RD(0x005)
#define IOCTL_UTIMES				IO_RD(0x006)
#define IOCTL_FSYNC				IO_ND(0x007)
#define  PARAM_FSYNC_ONLY_DATA				0x01
#define  PARAM_FSYNC_ASYNC				0x02
#define  PARAM_FSYNC_TREE				0x04
#define  PARAM_FSYNC_NO_FLASH				0x08
#define IOCTL_DUP				IO_ND(0x008)
#define IOCTL_FCNTL_GETFL			IO_ND(0x009)
#define IOCTL_FCNTL_SETFL			IO_ND(0x00a)
#define IOCTL_FPATHCONF				IO_ND(0x00b)
#define IOCTL_SELECT_READ			IO_ND(0x00c)
#define IOCTL_SELECT_WRITE			IO_ND(0x00d)
#define IOCTL_NREAD				IO_ND(0x00e)
#define IOCTL_RWV_NONBLOCK			IO_ND(0x00f)	/* returns != 0 --- yes, should set nonblock */
#define  PARAM_RWV_READ					0
#define  PARAM_RWV_WRITE				1
#define IOCTL_CAN_MMAP				IO_ND(0x010)
#define IOCTL_POLL				IO_ND(0x011)
#define IOCTL_GET_CAPABILITIES			IO_ND(0x012)

#define IOCTL_SWAPPER_ISUSED			IO_ND(0x101)	/* returns 0 --- empty swapper, 1 --- nonempty swapper */
#define IOCTL_SWAPPER_PUTPAGE			IO_RD(0x102)
#define IOCTL_SWAPPER_LDCACHE_GET_ERROR		IO_WR(0x180)
#define IOCTL_SWAPPER_LDCACHE_PREPARE		IO_RD(0x181)
#define IOCTL_SWAPPER_LDCACHE_CHECK		IO_ND(0x182)
#define IOCTL_SWAPPER_LDCACHE_RELOC		IO_ND(0x183)
#define IOCTL_SWAPPER_LDCACHE_SET_IFACE		IO_RD(0x184)
#define IOCTL_SWAPPER_LDCACHE_RELOC_SYM		IO_RW(0x185)
#define IOCTL_SWAPPER_LDCACHE_FINALIZE		IO_WR(0x186)
#define IOCTL_SWAPPER_LDCACHE_QUERY		IO_RW(0x187)
#define IOCTL_SWAPPER_LDCACHE_ATTACH		IO_RW(0x188)

#define IOCTL_SYSCALLS_UNAME			IO_WR(0x201)
#define IOCTL_SYSCALLS_QUERY_MEMORY		IO_WR(0x202)

#define IOCTL_TTY_GET_TERM_FLAGS		IO_ND(0x301)
#define IOCTL_TTY_FLUSH				IO_ND(0x303)
#define IOCTL_TTY_GET_CONTROL			IO_WR(0x304)
#define IOCTL_TTY_WAIT_CONTROL			IO_RD(0x305)
#define IOCTL_TTY_GET_WINSIZE			IO_WR(0x306)
#define IOCTL_TTY_WAIT_WINSIZE			IO_RD(0x307)
#define IOCTL_TTY_INCREASE_DETACH_SEQ		IO_ND(0x308)
#define IOCTL_TTY_PEEK				IO_WR(0x309)
#define IOCTL_TTY_NTAB				IO_ND(0x30a)
#define IOCTL_TTY_GET_SPEED			IO_ND(0x30b)
#define  PARAM_ISPEED					1
#define  PARAM_OSPEED					2

#define IOCTL_TTY_DTTY				IO_ND(0x311)
#define IOCTL_TTY_PUTBACK			IO_RD(0x313)
#define IOCTL_TTY_PUTBACK_EDIT			IO_ND(0x314)
#define IOCTL_TTY_AUTH				IO_ND(0x315)
#define IOCTL_TTY_GETAUTH			IO_ND(0x316)
#define IOCTL_TTY_ERASE_CLIPBOARD		IO_ND(0x317)

#define IOCTL_TTY_GETVIDEOMODE			IO_WR(0x321)
#define IOCTL_TTY_GETKBDMODE			IO_ND(0x322)
#define IOCTL_TTY_MOUSE_EVENT			IO_WR(0x323)
#define IOCTL_TTY_GETMOUSEMODE			IO_WR(0x324)
#define IOCTL_TTY_MOUSE_INFO			IO_WR(0x325)
#define IOCTL_TTY_WAITACTIVE			IO_RW(0x326)
#define  PARAM_WAIT_FOR_INACTIVE			1
#define  PARAM_WAIT_FOR_ACTIVE				2
#define  PARAM_WAIT_FOR_ACTIVE_AND_LOCK			3
#define  PARAM_WAIT_FOR_RELEASE_REQUEST			4
#define  PARAM_RELEASE					5
#define IOCTL_TTY_SETPALETTE			IO_RD(0x327)
#define IOCTL_TTY_SETDISPLAYSTART		IO_ND(0x328)
#define IOCTL_TTY_WAITRETRACE_SETDISPLAYSTART IO_ND(0x329)
#define IOCTL_TTY_WAITRETRACE			IO_ND(0x32a)
#define IOCTL_TTY_GET_PIXEL_CLOCK		IO_ND(0x32b)
#define IOCTL_TTY_AVAIL_ACCEL			IO_ND(0x32c)
#define IOCTL_TTY_DO_ACCEL			IO_RD(0x32d)
#define IOCTL_TTY_GET_FONT_MODE			IO_ND(0x32e)
#define  RESULT_GET_FONT_MODE_NONE			0x00
#define  RESULT_GET_FONT_MODE_EGA			0x01
#define  RESULT_GET_FONT_MODE_VGA			0x02
#define  RESULT_GET_FONT_MODE_ANY			0x04
#define IOCTL_TTY_GET_CHARSET			IO_WR(0x32f)
#define IOCTL_TTY_GET_FONT_FILE			IO_WR(0x330)
#define IOCTL_TTY_SET_KEYBOARD			IO_ND(0x331)
#define  PARAM_SET_KEYBOARD_PRIMARY			0
#define  PARAM_SET_KEYBOARD_SECONDARY			1
#define IOCTL_TTY_GET_KEYBOARD_NAME		IO_WR(0x332)
#define IOCTL_TTY_GETLED			IO_ND(0x333)

#define BLOB_TTY_FONT				0x301
#define BLOB_TTY_KEYMAP				0x302

#define IOCTL_ACCEPT				IO_WR(0x401)
#define IOCTL_BIND				IO_RD(0x402)
#define IOCTL_CONNECT				IO_RD(0x403)
#define IOCTL_GETPEERNAME			IO_WR(0x404)
#define IOCTL_GETSOCKNAME			IO_WR(0x405)
#define IOCTL_LISTEN				IO_ND(0x406)
#define IOCTL_GETSOCKOPT			IO_WR(0x407)
#define IOCTL_SETSOCKOPT			IO_RD(0x408)
#define IOCTL_SHUTDOWN				IO_ND(0x409)
#define IOCTL_SOCKET_LINGER			IO_ND(0x40a)
#define IOCTL_DHCP_OPTION			IO_WR(0x40b)

#define IOCTL_IF_GET_TYPE			IO_WR(0x501)
#define IOCTL_IF_WAIT_LINK			IO_RD(0x502)
#define IOCTL_IF_GET_LINK			IO_WR(0x503)
#define IOCTL_IF_SIGNAL_CHANGED_LINK		IO_ND(0x504)
#define IOCTL_IF_GET_MULTICAST			IO_ND(0x511)
#define  STATUS_MULTICAST_NONE				0
#define  STATUS_MULTICAST_SOME				1
#define  STATUS_MULTICAST_ALL				2
#define  STATUS_MULTICAST_PROMISC			3
#define IOCTL_IF_SET_MULTICAST			IO_RD(0x512)
#define  PARAM_MULTICAST_ADDRESS			1
#define  PARAM_MULTICAST_ALL				2
#define  PARAM_MULTICAST_PROMISC			3
#define IOCTL_IF_RESET_MULTICAST		IO_ND(0x513)

#define IOCTL_CONSOLE_SWITCH			IO_ND(0x601)
#define IOCTL_CONSOLE_SCROLL			IO_RD(0x602)
#define IOCTL_CONSOLE_NUM_VCS			IO_ND(0x603)
#define IOCTL_CONSOLE_VC			IO_ND(0x604)
#define IOCTL_CONSOLE_MOUSE			IO_RW(0x605)
#define IOCTL_CONSOLE_GET_CLIPBOARD		IO_WR(0x606)
#define IOCTL_CONSOLE_ERASE_CLIPBOARD		IO_ND(0x607)

/* TTY$TELN.255.255.255.255.65536 */
#define  TTYSTR_LEN				48
#define IOCTL_TTYSRVR_CLEAR			IO_ND(0x701)
#define IOCTL_TTYSRVR_MAKETTY			IO_RD(0x702)
#define IOCTL_TTYSRVR_SENDCHR			IO_RD(0x703)
#define IOCTL_TTYSRVR_RCVCHR			IO_RW(0x704)
#define IOCTL_TTYSRVR_CLOSETTY			IO_RD(0x705)
#define IOCTL_TTYSRVR_WINSIZE			IO_RD(0x706)	/* params has (width << 16) + height */
#define IOCTL_TTYSRVR_GETAUTH			IO_RD(0x707)
#define IOCTL_TTYSRVR_EOF			IO_RD(0x708)
#define IOCTL_TTYSRVR_RAW			IO_RD(0x709)

#define IOCTL_SND_SYNC				IO_ND(0x801)
#define  PARAM_SND_SYNC_RESET				0
#define  PARAM_SND_SYNC_SYNC				1
#define  PARAM_SND_SYNC_POST				2
#define IOCTL_SND_GETRATE			IO_ND(0x802)
#define IOCTL_SND_GETCHANNELS			IO_ND(0x803)
#define IOCTL_SND_GETFORMAT			IO_ND(0x804)
#define IOCTL_SND_GETFORMATMASK			IO_ND(0x805)
#define IOCTL_SND_GETSPACE			IO_WR(0x806)
#define  PARAM_SND_GETSPACE_CURRENT			0
#define  PARAM_SND_GETSPACE_PLAYBACK			1
#define  PARAM_SND_GETSPACE_RECORD			2
#define IOCTL_SND_GETCAPS			IO_ND(0x807)
#define IOCTL_SND_GETTRIGGER			IO_ND(0x808)
#define IOCTL_SND_SETTRIGGER			IO_ND(0x809)
#define IOCTL_SND_GETPTR			IO_WR(0x80a)
#define  PARAM_SND_GETPTR_PLAYBACK			1
#define  PARAM_SND_GETPTR_RECORD			2
#define IOCTL_SND_GETODELAY			IO_ND(0x80b)
#define IOCTL_SND_GETERROR			IO_WR(0x80c)
#define IOCTL_SND_MIXREAD			IO_ND(0x80d)
#define IOCTL_SND_MIXWRITE			IO_ND(0x80e)
#define  PARAM_MIX_IDX_MASK				0xff
#define  PARAM_MIX_DATA_SHIFT				8

#define IOCTL_BIO_GET_OPTIMAL_REQUEST_SIZE	IO_ND(0x901)
#define  PARAM_BIO_GET_OPTIMAL_REQUEST_SIZE_READ	0
#define  PARAM_BIO_GET_OPTIMAL_REQUEST_SIZE_WRITE	1
#define IOCTL_BIO_PHYSICAL_BLOCKSIZE		IO_ND(0x902)
#define IOCTL_BIO_PARTITION_BLOCKSIZE		IO_ND(0x903)
#define IOCTL_BIO_FDGETPRM			IO_WR(0x904)
#define IOCTL_BIO_GET_FAT_OFFSET		IO_WR(0x905)
#define IOCTL_BIO_SCSI_PASS_THROUGH		IO_RD(0x906)
#define  PARAM_BIO_SCSI_PASS_THROUGH_COMMAND		0
#define  PARAM_BIO_SCSI_PASS_THROUGH_MAX_SIZE		1
#define  PARAM_BIO_SCSI_PASS_THROUGH_EMULATED_HOST	2
#define IOCTL_BIO_PRETEND_MEDIA_CHANGE		IO_ND(0x907)

#define IOCTL_EAP_OFFER_METHODS			IO_RW(0xa01)
#define IOCTL_EAP_GET_PACKET			IO_RW(0xa02)
#define IOCTL_EAP_SEND_PACKET			IO_RD(0xa03)
#define IOCTL_EAP_GET_STATUS			IO_WR(0xa04)

#endif
