#ifndef __SPAD_IRQ_H
#define __SPAD_IRQ_H

#include <SPAD/AC.H>
#include <SYS/TYPES.H>

#include <ARCH/IRQ.H>

__BEGIN_DECLS

#define IRQ_REQUEST_EXCLUSIVE	0x01
#define IRQ_REQUEST_SHARED	0x02

#define IRQ_REQUEST_RT_HANDLER	0x10
#define IRQ_REQUEST_AST_HANDLER	0x20

#define IRQ_REQUEST_MASKED	0x80

int KERNEL$REQUEST_IRQ(int irq, IRQ_HANDLE **handle, int flags, IRQ_STUB *call, void *data, __const__ char *desc);
void KERNEL$RELEASE_IRQ(IRQ_HANDLE *irq, int flags, IRQ_STUB *call, void *data);

void KERNEL$MASK_IRQ(IRQ_HANDLE *irq);
void KERNEL$UNMASK_IRQ(IRQ_HANDLE *irq);

void KERNEL$DI_HW(void);
void KERNEL$EI_HW(void);

int KERNEL$QUERY_IRQ_ROUTING(__const__ char *bus_string, unsigned bus_id, unsigned bus_irq);

__END_DECLS

#endif
