#ifndef __SPAD_ISADMA_H
#define __SPAD_ISADMA_H

#include <SYS/TYPES.H>

#define DMA_8BIT_MIN	0
#define DMA_8BIT_MAX	4

#define DMA_16BIT_MIN	5
#define DMA_16BIT_MAX	8

__BEGIN_DECLS

int ISADMA$REQUEST_CHANNEL(int channel);
void ISADMA$RELEASE_CHANNEL(int channel);
void ISADMA$SETUP_TRANSFER(int channel, int wr, int autoinit, unsigned long addr, unsigned long size);
void ISADMA$SETUP_AUTOINIT(int channel, unsigned long addr, unsigned long size);
unsigned long ISADMA$GET_ADDRESS(int channel);
void ISADMA$END_TRANSFER(int channel);
void ISADMA$PAUSE_TRANSFER(int channel);
void ISADMA$RESUME_TRANSFER(int channel);

__END_DECLS

#endif
