#ifndef __SPAD_KEYBOARD_H
#define __SPAD_KEYBOARD_H

#define KC_ESC		0x01
#define KC_1		0x02
#define KC_2		0x03
#define KC_3		0x04
#define KC_4		0x05
#define KC_5		0x06
#define KC_6		0x07
#define KC_7		0x08
#define KC_8		0x09
#define KC_9		0x0a
#define KC_0		0x0b
#define KC__		0x0c
#define KC_EQ		0x0d
#define KC_BACKSPACE	0x0e
#define KC_TAB		0x0f
#define KC_Q		0x10
#define KC_W		0x11
#define KC_E		0x12
#define KC_R		0x13
#define KC_T		0x14
#define KC_Y		0x15
#define KC_U		0x16
#define KC_I		0x17
#define KC_O		0x18
#define KC_P		0x19
#define KC_LB		0x1a
#define KC_RB		0x1b
#define KC_ENTER	0x1c
#define KC_CTRL		0x1d
#define KC_A		0x1e
#define KC_S		0x1f
#define KC_D		0x20
#define KC_F		0x21
#define KC_G		0x22
#define KC_H		0x23
#define KC_J		0x24
#define KC_K		0x25
#define KC_L		0x26
#define KC_SC		0x27
#define KC_AP		0x28
#define KC_BAP		0x29
#define KC_SHIFT	0x2a
#define KC_BSL		0x2b
#define KC_Z		0x2c
#define KC_X		0x2d
#define KC_C		0x2e
#define KC_V		0x2f
#define KC_B		0x30
#define KC_N		0x31
#define KC_M		0x32
#define KC_COM		0x33
#define KC_DOT		0x34
#define KC_SL		0x35
#define KC_RIGHT_SHIFT	0x36
#define KC_NUM_MULT	0x37
#define KC_ALT		0x38
#define KC_SPACE	0x39
#define KC_CAPS_LOCK	0x3a
#define KC_F1		0x3b
#define KC_F2		0x3c
#define KC_F3		0x3d
#define KC_F4		0x3e
#define KC_F5		0x3f
#define KC_F6		0x40
#define KC_F7		0x41
#define KC_F8		0x42
#define KC_F9		0x43
#define KC_F10		0x44
#define KC_NUM_LOCK	0x45
#define KC_SCROLL_LOCK	0x46
#define KC_NUM_7	0x47
#define KC_NUM_8	0x48
#define KC_NUM_9	0x49
#define KC_NUM_MINUS	0x4a
#define KC_NUM_4	0x4b
#define KC_NUM_5	0x4c
#define KC_NUM_6	0x4d
#define KC_NUM_PLUS	0x4e
#define KC_NUM_1	0x4f
#define KC_NUM_2	0x50
#define KC_NUM_3	0x51
#define KC_NUM_0	0x52
#define KC_NUM_DOT	0x53
#define KC_SYSRQ	0x54
#define KC_BSL2		0x56

#define KC_F11		0x57
#define KC_F12		0x58

#define KC_NUM_ENTER	0x60

#define KC_RIGHT_CTRL	0x61
#define KC_NUM_DIV	0x62
#define KC_PRINT_SCREEN	0x63
#define KC_RIGHT_ALT	0x64
#define KC_BREAK	0x65

#define KC_HOME		0x66
#define KC_UP		0x67
#define KC_PAGE_UP	0x68
#define KC_LEFT		0x69
#define KC_RIGHT	0x6a
#define KC_END		0x6b
#define KC_DOWN		0x6c
#define KC_PAGE_DOWN	0x6d
#define KC_INS		0x6e
#define KC_DEL		0x6f

#define KC_PAUSE	0x77

/*
 * New microsoft keyboard is rumoured to have
 * e0 5b (left window button), e0 5c (right window button),
 * e0 5d (menu button). [or: LBANNER, RBANNER, RMENU]
 * [or: Windows_L, Windows_R, TaskMan]
 */
#define KC_MSLW		0x7d
#define KC_MSRW		0x7e
#define KC_MSTM		0x7f

#define KC_MAX		0x80

#endif
