#ifndef __SPAD_LIBC_H
#define __SPAD_LIBC_H

#include <STDARG.H>

#include <SYS/TYPES.H>
#include <ARCH/LIBC.H>
#include <ERRNO.H>

__BEGIN_DECLS

int __vxprintf(void (*__print)(void *__data, __const__ char *__c, int __l), void *__data, __const__ char *__fmt, va_list __args);
int __PRINTF_ATTR__(1,2) __critical_printf(__const__ char *__fmt, ...);
int __critical_vprintf(__const__ char *__fmt, va_list __args);
void __PRINTF_ATTR__(1,2) __NORET_ATTR__ KERNEL$SUICIDE(__const__ char *__fmt, ...);
extern int (* volatile KERNEL$SUICIDE_DUMP)(void);
extern void * volatile KERNEL$SUICIDE_DUMP_PARAM;

int __PRINTF_ATTR__(1,2) _printf(__const__ char *__fmt, ...);
int _vprintf(__const__ char *__fmt, va_list __args);
int __PRINTF_ATTR__(1,2) _eprintf(__const__ char *__fmt, ...);
int _veprintf(__const__ char *__fmt, va_list __args);
int __PRINTF_ATTR__(2,3) _fprintf(int __h, __const__ char *__fmt, ...);
int _vfprintf(int __h, __const__ char *__fmt, va_list __args);

#define __debug_printf __critical_printf

void KERNEL$STACK_DUMP(void);

int _vsnprintf(char *__str, size_t __n, __const__ char *__fmt, va_list __args);
int __PRINTF_ATTR__(3,4) _snprintf(char *__str, size_t __n, __const__ char *__fmt, ...);

#define __MAX_STR_LEN		256

int __check_logical_name(char *__name, int __chg);

struct __param_table {
	char *__name;
	int __type;	/* __PARAM_xxx */
	long __min;	/* bool: value = value & ~min | max */
	long __max;
};

struct __param_custom {
	int (*__f)(__const__ char *, __const__ char *, void *);
	void *__p;
};

#define __PARAM_BOOL		1
#define __PARAM_BOOL_X		2
#define __PARAM_INT		3
#define __PARAM_UNSIGNED_INT	4
#define __PARAM_LONG		5
#define __PARAM_UNSIGNED_LONG	6
#define __PARAM_INT64		7
#define __PARAM_UNSIGNED_INT64	8
#define __PARAM_PTR		9
#define __PARAM_STRING		10
#define __PARAM_NEWSTRING	11
#define __PARAM_CUSTOM		12
#define __PARAM_EXTD		13
#define __PARAM_EXTD_ONE	14

#define __STATE_NOFIRST		1
#define __STATE_NOOPT		2
#define __STATE_EXT_NOSEP	4

int __get_number(__const__ char *__start, __const__ char *__end, int __signed, long *__nump);
int __get_64_number(__const__ char *__start, __const__ char *__end, int __signed, __s64 *__nump);
int __parse_extd_param(__const__ char **__arg, int *__state, __const__ struct __param_table *__p, void * const *__vars, __const__ char **__opt, __const__ char **__optend, __const__ char **__val, __const__ char **__valend);
int __parse_params(__const__ char *__const__ **__argv, int *__state, __const__ struct __param_table *__p, void * const *__vars, __const__ char **__opt, __const__ char **__optend, __const__ char **__val);
int __accumulate_params(char **__param, const char *__opt, const char *__optend, const char *__val, const char *__valend);

void __NORET_ATTR__ _exit_msg(int __status, __const__ char *__msg);
void _stop(char *__msg);
void _background(char *__msg);

__const__ char *__strexception(int __except);
__const__ char *__exceptionmsg(int __except, void *__ip, void *__address, long __error, int __resolve_sym);
int __exception2signal(int __except);

__END_DECLS

#endif
