#ifndef __SPAD_PAGEZONE_H
#define __SPAD_PAGEZONE_H

#include <SPAD/VM.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

typedef struct __pagezone PAGEZONE;
typedef struct __kpagezone KPAGEZONE;

void VFS$ZINIT(PAGEZONE *z, int type, __const__ char *name);
void VFS$ZRESERVE(PAGEZONE *z, PAGE *p);
PAGE *VFS$ZALLOC(PAGEZONE *z);
void VFS$ZFREE(PAGEZONE *z, PAGE *p);
void VFS$ZDONE(PAGEZONE *z);

void VFS$KZINIT(KPAGEZONE *z, __const__ char *name);
void VFS$KZRESERVE(KPAGEZONE *z, void *p);
void *VFS$KZALLOC(KPAGEZONE *z);
void VFS$KZFREE(KPAGEZONE *z, void *p);
void VFS$KZDONE(KPAGEZONE *z);


struct __pagezone {
	PAGE *next;
	unsigned long allocated;
	int reserved;
	int type;
	__const__ char *name;
};

static __finline__ PAGE *PAGEZONE_ALLOC(PAGEZONE *z, PAGE *(*method)(int type), int reserved)
{
	PAGE *p;
	if (__unlikely((unsigned)z->reserved > (unsigned)reserved)) p = VFS$ZALLOC(z);
	else if (__likely((p = method(z->type)) != NULL)) z->allocated++;
	return p;
}

static __finline__ void PAGEZONE_FREE(PAGEZONE *z, PAGE *p, int reserved)
{
	if (__likely((unsigned)z->reserved >= (unsigned)reserved) && __likely(z->allocated != 0)) {
		z->allocated--;
		KERNEL$FREE_USER_PAGE(p, z->type);
	} else VFS$ZFREE(z, p);
}

struct __kpagezone {
	void *next;
	unsigned long allocated;
	int reserved;
	__const__ char *name;
};

static __finline__ void *KPAGEZONE_ALLOC(KPAGEZONE *z)
{
	void *p;
	if (__unlikely(z->next != NULL)) p = VFS$KZALLOC(z);
	else if (__likely((p = KERNEL$ALLOC_KERNEL_PAGE(VM_TYPE_CACHED_MAPPED)) != NULL)) z->allocated++;
	return p;
}

static __finline__ void KPAGEZONE_FREE(KPAGEZONE *z, void *p)
{
	if (__likely(z->allocated != 0)) {
		z->allocated--;
		KERNEL$FREE_KERNEL_PAGE(p, VM_TYPE_CACHED_MAPPED);
	} else VFS$KZFREE(z, p);
}

__END_DECLS

#endif
