#ifndef __SPAD_READDIR_H
#define __SPAD_READDIR_H

#include <SPAD/AC.H>
#include <SPAD/ALLOC.H>
#include <SPAD/DEV.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

/* when creating request, set entries == NULL, readdir_pages == NULL */

typedef struct {	/* this structure is moved in opendir, should not */
	IORQ_HEAD;	/* contain pointers to itself */
	int flags;
	__const__ char *path;
	CWD *cwd;
	unsigned long n_entries;
	struct dirent **entries;
	unsigned long n_entries_allocated;
	struct readdir_buffer *readdir_pages;
} READDIR_RQ;

IO_STUB KERNEL$READDIR;
void KERNEL$FREE_READDIR(READDIR_RQ *r);

__END_DECLS

#endif
