#ifndef __SPAD_SHELL_H
#define __SPAD_SHELL_H

#include <SPAD/AC.H>
#include <SPAD/LIBC.H>
#include <SPAD/ALLOC.H>
#include <SPAD/DEV.H>
#include <SPAD/THREAD.H>
#include <SPAD/LIST.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

typedef struct __shell_context CTX;

typedef struct __shrcrq SHRCRQ;

struct __shrcrq {
	IORQ_HEAD;
	CTX *ctx;
	__const__ char *ptr;
	size_t len;
	__const__ char **arg;
	int narg;

	__const__ char *error_msg;	/* shell places a pointer here */
};

extern IO_STUB SHELL$RUN_COMMANDS;

typedef struct {
	IORQ_HEAD;
	CTX *ctx;
	MALLOC_REQUEST mrq;
} SHCCRQ;

extern IO_STUB SHELL$CREATE_CONTEXT;
void SHELL$DESTROY_CONTEXT(CTX *ctx);

#define SHELL_NO_OUTPUT		-1
#define SHELL_CONSOLE_OUTPUT	-2

void SHELL$SET_TTY(CTX *ctx, int std_in, int std_out, int std_err, char std_in_tty, char std_out_tty, char std_err_tty, char no_close);
void SHELL$SET_CWD(CTX *ctx, CWD *cwd, int no_free);

void SHELL$ESC_COPY(char *dest, __const__ char *src);

__END_DECLS

#endif
