#ifndef __SPAD_SLAB_H
#define __SPAD_SLAB_H

#include <ARCH/SETUP.H>
#include <SYS/TYPES.H>
#include <ARCH/BSF.H>
#include <ARCH/SPL.H>
#include <STRING.H>
#include <SPAD/LIST.H>

__BEGIN_DECLS

#ifndef __SLHEAD_DEFINED
#define __SLHEAD_DEFINED

struct __slhead {	/* size is hardcoded in malloc assember */
	LIST_HEAD pages;
	LIST_HEAD free_pages;
	LIST_HEAD full_pages;
	struct __slpage *__current_page;
	unsigned __objsize;
	unsigned char __objalign_bit;
	unsigned char __alloc_type;
	unsigned short __n_reserved_pages;
	unsigned __n_pages;
	unsigned __n_free_pages;
	long *__page_limit;
	void (*__ctor)(struct __slhead *__g, void *__o);
	LIST_ENTRY global_list;
	char *__name;
};

struct __slpage {
	struct __slentry *__freelist;
	struct __slhead *__head;
	LIST_ENTRY list;
	int __n_alloc;
};

struct __slentry {
	struct __slentry *__nexte;
};

#endif

#include <ARCH/SLAB.H>

#ifndef __static__
#define __static__ static
#endif

/* !!! WARNING: constructor cannot contruct first pointer of an object --- it is   used as a free-list link */

int KERNEL$SLAB_ENTRIES_PER_PAGE(unsigned size, unsigned align);
void KERNEL$SLAB_INIT(struct __slhead *__h, unsigned __size, unsigned __align, int __alloc_type, void (*__ctor)(struct __slhead *__g, void *__o), long *__limit, char *__name);
void KERNEL$SLAB_DESTROY(struct __slhead *__h);
int KERNEL$SLAB_EMPTY(struct __slhead *__h);
int KERNEL$SLAB_RESERVE(struct __slhead *__h, unsigned __n);
int KERNEL$SLAB_REAP(void);
void KERNEL$SLABS_DUMP(void);

struct __slentry *__MALLOC_ATTR__ KERNEL$__SLAB_ALLOC(struct __slhead *__h);
void KERNEL$__SLAB_FREE_PAGE(struct __slpage *__p);
void KERNEL$__SLAB_PARTIAL_PAGE(struct __slpage *__p);

#ifdef __NO_INLINES
unsigned __slsize(void *__s);
#else
__static__ __finline__ unsigned __slsize(void *__s)
{
	struct __slpage *__p;
	__p = (struct __slpage *)((unsigned long)__s & __NOT_PAGE_CLUSTER_SIZE_MINUS_1);
	return __p->__head->__objsize;
}
#endif

#ifdef __NO_INLINES
unsigned __slheadsize(struct __slhead *__h);
#else
__static__ __finline__ unsigned __slheadsize(struct __slhead *__h)
{
	return __h->__objsize;
}
#endif

__END_DECLS

#endif
