#ifndef __SPAD_SPINLOCK_H
#define __SPAD_SPINLOCK_H

#include <SYS/TYPES.H>

typedef __u16 __spinlock_val_t;
typedef __u32 __spinlock_val_double_t;
#define __SPINLOCK_XADD __LOCK_XADD16

typedef union {
	struct {
		__spinlock_val_t __ticket;
		__spinlock_val_t __value;
	} __s1;
	__spinlock_val_double_t __s2;
} SPINLOCK;

void KERNEL$SPINLOCK_INIT(SPINLOCK *);
void KERNEL$SPINLOCK_LOCK(SPINLOCK *);
void KERNEL$SPINLOCK_UNLOCK(SPINLOCK *);

#endif
