#ifndef __SPAD_SYSLOG_H
#define __SPAD_SYSLOG_H

#include <ARCH/SETUP.H>
#include <SPAD/LIBC.H>
#include <SYS/TYPES.H>
#include <SPAD/AC.H>
#include <SPAD/SYSLDEF.H>

__BEGIN_DECLS

void KERNEL$SYSLOGV(int lclass, __const__ char *device, __const__ char *msg, va_list args);
void __PRINTF_ATTR__(3,4) KERNEL$SYSLOG(int lclass, __const__ char *device, __const__ char *msg, ...);

typedef struct {
	IORQ_HEAD;
	int lclass;
	__const__ char *device;
	char *msg;
} LOGRQ;

extern IO_STUB KERNEL$SYNC_SYSLOG;

__END_DECLS

#endif
