#ifndef __SPAD_TIMER_H
#define __SPAD_TIMER_H

#include <ARCH/TIME.H>
#include <SPAD/LIST.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

void KERNEL$SET_TIMER(jiffies_t time, TIMER *t);
void KERNEL$DEL_TIMER(TIMER *t);
void KERNEL$SET_TIMER_NEVER(TIMER *t);
int KERNEL$IS_TIMER_NEVER(TIMER *t);

void KERNEL$SLEEP(jiffies_t time);
int KERNEL$SLEEP_CANCELABLE(jiffies_t time);

#define __TIMER_MAGIC	((void *)1)	/* set also in ASM.S */

static __finline__ void INIT_TIMER(TIMER *t)
{
	t->list.next = __TIMER_MAGIC;
}

static __finline__ void SET_TIMER_NEVER(TIMER *t)
{
#if __DEBUG >= 2
	KERNEL$SET_TIMER_NEVER(t);
#else
	VOID_LIST_ENTRY(&t->list);
#endif
}

#if __DEBUG >= 2
#define IS_TIMER_NEVER(t)	KERNEL$IS_TIMER_NEVER(t)
#else
#define IS_TIMER_NEVER(t)	((t)->list.next == &(t)->list)
#endif

#define DECL_TIMER(t)	TIMER t = { __TIMER_MAGIC }

__END_DECLS

#endif
