#ifndef __SPAD_USBHC_H
#define __SPAD_USBHC_H

#include <SPAD/USB.H>
#include <SPAD/AC.H>
#include <SYS/TYPES.H>
#include <ARCH/SETUP.H>
#include <STDARG.H>

extern __const__ unsigned USB$SIZEOF_USB;
extern char *USB$HC_DEFAULT_PLUG_SCRIPT;

#define USB_ROOT_HUB_ADDR	-1

typedef struct {
	int flags;
	USB_ENDPOINT *(*alloc_endpoint)(USB *usb, unsigned speed, int type, int addr, int pipe, unsigned pkt_size, int interval, unsigned n_rq, unsigned rq_size);
	void (*disable_endpoint)(USB_ENDPOINT *endpoint);
	void (*free_endpoint)(USB_ENDPOINT *endpoint);
} USB_HC_OPERATIONS;

#define USB_HC_20		1

int USB$HC_REGISTER(USB *usb, __const__ USB_HC_OPERATIONS *op, char *dev_name, int errorlevel, char *plug);
int USB$HC_PREPARE_UNREGISTER(USB *usb);
void USB$HC_UNREGISTER(USB *usb);

int USB$HC_DCALL(void *ptr, __const__ char *dcall_type, int cmd, va_list list);
extern __const__ char USB$HC_DCALL_TYPE[];
int USB$HC_DCTL(void *ptr, void **unload, const char * const argv[]);
void USB$HC_GENERIC_ROOT_CTRL(USB *usb, USB_CTRL_REQUEST *urq);

int USB$HC_ENDPOINT_BANDWIDTH(int type, int speed, unsigned pkt_size);

#if __DEBUG < 1
#define HC_CHECK_SPL(fn) do { } while (0)
#else
#define HC_CHECK_SPL(fn)						\
do {									\
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_USB)))			\
		KERNEL$SUICIDE(fn " AT SPL %08X", KERNEL$SPL);		\
} while (0)
#endif

#endif
