#ifndef __SPAD_USBHUB_H
#define __SPAD_USBHUB_H

#include <SYS/TYPES.H>
#include <SPAD/USB.H>

#define USB_HUB_MAXPORTS		255

#define USB_HUB_SUBCLASS		0
#define USB_HUB_SUBCLASS_NONSTD		1

#define USB_HUB_PROTOCOL_SINGLE_TT	0
#define USB_HUB_PROTOCOL_MULTIPLE_TT	1

#define USBHUB_REQ_GET_HUB_DESCRIPTOR	(USB_REQ_GET_DESCRIPTOR | USB_CTRL_DIR_IN | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_DEVICE)
#define USBHUB_REQ_CLEAR_HUB_FEATURE	(USB_REQ_CLEAR_FEATURE | USB_CTRL_DIR_OUT | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_DEVICE)
#define USBHUB_REQ_SET_HUB_FEATURE	(USB_REQ_SET_FEATURE | USB_CTRL_DIR_OUT | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_DEVICE)
#define USBHUB_REQ_GET_HUB_STATUS	(USB_REQ_GET_STATUS | USB_CTRL_DIR_IN | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_DEVICE)
#define USBHUB_REQ_CLEAR_PORT_FEATURE	(USB_REQ_CLEAR_FEATURE | USB_CTRL_DIR_OUT | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_OTHER)
#define USBHUB_REQ_SET_PORT_FEATURE	(USB_REQ_SET_FEATURE | USB_CTRL_DIR_OUT | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_OTHER)
#define USBHUB_REQ_GET_PORT_STATUS	(USB_REQ_GET_STATUS | USB_CTRL_DIR_IN | USB_CTRL_TYPE_CLASS | USB_CTRL_RECIP_OTHER)

typedef struct {
	__u8 bDescLength;
	__u8 bDescriptorType;
	__u8 bNbrPorts;
	__u8 wHubCharacteristics;
	__u8 wHubCharacteristics2;
	__u8 bPwrOn2PwrGood;
	__u8 bHubContrCurrent;
	__u8 DeviceRemovable[(USB_HUB_MAXPORTS + 1 + 7) / 8 * 2];
} USB_DESCRIPTOR_HUB;

#define USB_DESCRIPTOR_HUB_SIZE			sizeof(USB_DESCRIPTOR_HUB)
#define USB_DESCRIPTOR_HUB_MIN_SIZE		7

#define USB_DT_HUB				0x29

#define USB_DESCRIPTOR_HUB_CHAR_POWER_MASK		0x03
#define USB_DESCRIPTOR_HUB_CHAR_POWER_GANGED		0x00
#define USB_DESCRIPTOR_HUB_CHAR_POWER_INDIVIDUAL	0x01
#define USB_DESCRIPTOR_HUB_CHAR_POWER_NONE		0x02
#define USB_DESCRIPTOR_HUB_CHAR_COMPOUND_DEVICE		0x04
#define USB_DESCRIPTOR_HUB_CHAR_OC_MASK			0x18
#define USB_DESCRIPTOR_HUB_CHAR_OC_GLOBAL		0x00
#define USB_DESCRIPTOR_HUB_CHAR_OC_INDIVIDUAL		0x08
#define USB_DESCRIPTOR_HUB_CHAR_OC_NONE			0x10
#define USB_DESCRIPTOR_HUB_CHAR_TT_THINK_MASK		0x60
#define USB_DESCRIPTOR_HUB_CHAR_TT_THINK_8		0x00
#define USB_DESCRIPTOR_HUB_CHAR_TT_THINK_16		0x20
#define USB_DESCRIPTOR_HUB_CHAR_TT_THINK_24		0x40
#define USB_DESCRIPTOR_HUB_CHAR_TT_THINK_32		0x60
#define USB_DESCRIPTOR_HUB_CHAR_PORT_INDICATOR		0x80

#define USB_HUB_FEAT_LOCAL_POWER	0x00
#define USB_HUB_FEAT_OVER_CURRENT	0x01
#define USB_HUB_FEAT_C_LOCAL_POWER	0x10
#define USB_HUB_FEAT_C_OVER_CURRENT	0x11

#define USB_HUB_STAT_LOCAL_POWER	(1 << USB_HUB_FEAT_LOCAL_POWER)
#define USB_HUB_STAT_OVER_CURRENT	(1 << USB_HUB_FEAT_OVER_CURRENT)
#define USB_HUB_STAT_C_LOCAL_POWER	(1 << USB_HUB_FEAT_C_LOCAL_POWER)
#define USB_HUB_STAT_C_OVER_CURRENT	(1 << USB_HUB_FEAT_C_OVER_CURRENT)

#define USB_PORT_FEAT_CONNECTION	0x00
#define USB_PORT_FEAT_ENABLE		0x01
#define USB_PORT_FEAT_SUSPEND		0x02
#define USB_PORT_FEAT_OVER_CURRENT	0x03
#define USB_PORT_FEAT_RESET		0x04
#define USB_PORT_FEAT_POWER		0x08
#define USB_PORT_FEAT_LOWSPEED		0x09
#define USB_PORT_FEAT_HIGHSPEED		0x0a
#define USB_PORT_FEAT_C_CONNECTION	0x10
#define USB_PORT_FEAT_C_ENABLE		0x11
#define USB_PORT_FEAT_C_SUSPEND		0x12
#define USB_PORT_FEAT_C_OVER_CURRENT	0x13
#define USB_PORT_FEAT_C_RESET		0x14
#define USB_PORT_FEAT_TEST		0x15
#define USB_PORT_FEAT_INDICATOR		0x16

#define USB_PORT_STAT_CONNECTION	(1 << USB_PORT_FEAT_CONNECTION)
#define USB_PORT_STAT_ENABLE		(1 << USB_PORT_FEAT_ENABLE)
#define USB_PORT_STAT_SUSPEND		(1 << USB_PORT_FEAT_SUSPEND)
#define USB_PORT_STAT_OVER_CURRENT	(1 << USB_PORT_FEAT_OVER_CURRENT)
#define USB_PORT_STAT_RESET		(1 << USB_PORT_FEAT_RESET)
#define USB_PORT_STAT_POWER		(1 << USB_PORT_FEAT_POWER)
#define USB_PORT_STAT_LOWSPEED		(1 << USB_PORT_FEAT_LOWSPEED)
#define USB_PORT_STAT_HIGHSPEED		(1 << USB_PORT_FEAT_HIGHSPEED)
#define USB_PORT_STAT_C_CONNECTION	(1 << USB_PORT_FEAT_C_CONNECTION)
#define USB_PORT_STAT_C_ENABLE		(1 << USB_PORT_FEAT_C_ENABLE)
#define USB_PORT_STAT_C_SUSPEND		(1 << USB_PORT_FEAT_C_SUSPEND)
#define USB_PORT_STAT_C_OVER_CURRENT	(1 << USB_PORT_FEAT_C_OVER_CURRENT)
#define USB_PORT_STAT_C_RESET		(1 << USB_PORT_FEAT_C_RESET)
#define USB_PORT_STAT_TEST		(1 << USB_PORT_FEAT_TEST)
#define USB_PORT_STAT_INDICATOR		(1 << USB_PORT_FEAT_INDICATOR)

int USB$HUB_TEST(USB_DEV_INTERFACE *iface, long tt);
int USB$HUB_ATTACH(USB_DEV_INTERFACE *iface);

#endif
