#ifndef __SPAD_WQ_H
#define __SPAD_WQ_H

#include <SPAD/AC.H>
#include <ARCH/BARRIER.H>
#include <ARCH/SETUP.H>
#include <SYS/TYPES.H>
#include <SPAD/LIST.H>

__BEGIN_DECLS

typedef struct __wq WQ;

#if __DEBUG_WQ
typedef struct {
	char zero[1];
	__const__ char *(*print_wq)(WQ *wq);
} WQ_DESC;
#define MAKE_WQ_DESC(name_, code_)	\
static __const__ char *name_##_fn(WQ *wq) code_ static __const__ WQ_DESC name_ = { 0, name_##_fn };
#else
#define MAKE_WQ_DESC(name_, code_)
#endif

struct __wq {
	struct __wq *next;
	struct __wq *prev;
#if __DEBUG_WQ
	LIST_ENTRY list;
	__const__ WQ_DESC *desc;
#endif
};

#if __DEBUG_WQ
#define WQ_DECL(symbol_, name_) WQ symbol_ = { &symbol_, &symbol_, { NULL, NULL }, (__const__ WQ_DESC *)(name_) }
#define WQ_INIT(wq_, name_) ((wq_)->next = (wq_)->prev = (wq_), (wq_)->list.next = (wq_)->list.prev = NULL, (wq_)->desc = (__const__ WQ_DESC *)(name_))
#else
#define WQ_DECL(symbol_, name_) WQ symbol_ = { &symbol_, &symbol_ }
#define WQ_INIT(wq_, name_) ((wq_)->next = (wq_)->prev = (wq_))
#endif

IORQ *KERNEL$WQ_GET_ONE(WQ *wq);
void KERNEL$WQ_WAKE_ONE(WQ *wq);
void KERNEL$WQ_WAKE_ALL(WQ *wq);

#define WQ_EMPTY(wq) (*(volatile struct __wq **)&(wq)->next == (wq))

#if !__DEBUG_WQ
#define __WQ_LINE_ARG_DECL
#define __WQ_LINE_ARG_PASS
#else
#define __WQ_LINE_ARG_DECL	, int line
#define __WQ_LINE_ARG_PASS	, line
#endif

void KERNEL$WQ_WAIT(WQ *wq, IORQ *rq __WQ_LINE_ARG_DECL);
void KERNEL$WQ_WAIT_SYNC(WQ *wq __WQ_LINE_ARG_DECL);
long KERNEL$WQ_WAIT_SYNC_SIGINTERRUPT(WQ *wq __WQ_LINE_ARG_DECL);
long KERNEL$WQ_WAIT_SYNC_CANCELABLE(WQ *wq __WQ_LINE_ARG_DECL);

#if !__DEBUG_WQ

#define WQ_WAIT(wq, io, fn)					\
do {								\
	(io)->tmp1 = (unsigned long)(fn);			\
	KERNEL$WQ_WAIT(wq, (IORQ *)(void *)(io));		\
} while (0)
#define WQ_WAIT_F(wq, io)					\
do {								\
	KERNEL$WQ_WAIT(wq, (IORQ *)(void *)(io));		\
} while (0)
#define WQ_WAIT_SYNC(wq)					\
do {								\
	KERNEL$WQ_WAIT_SYNC(wq);				\
} while (0)
#define WQ_WAIT_SYNC_SIGINTERRUPT(wq) KERNEL$WQ_WAIT_SYNC_SIGINTERRUPT(wq)
#define WQ_WAIT_SYNC_CANCELABLE(wq) KERNEL$WQ_WAIT_SYNC_CANCELABLE(wq)

#else

#define WQ_WAIT(wq, io, fn)					\
do {								\
	(io)->tmp1 = (unsigned long)(fn);			\
	KERNEL$WQ_WAIT(wq, (IORQ *)(void *)(io), __LINE__);	\
} while (0)
#define WQ_WAIT_F(wq, io)					\
do {								\
	KERNEL$WQ_WAIT(wq, (IORQ *)(void *)(io), __LINE__);	\
} while (0)
#define WQ_WAIT_SYNC(wq)					\
do {								\
	KERNEL$WQ_WAIT_SYNC(wq, __LINE__);			\
} while (0)
#define WQ_WAIT_SYNC_SIGINTERRUPT(wq) KERNEL$WQ_WAIT_SYNC_SIGINTERRUPT(wq, __LINE__)
#define WQ_WAIT_SYNC_CANCELABLE(wq) KERNEL$WQ_WAIT_SYNC_CANCELABLE(wq, __LINE__)

#endif

#define WQ_GET_ONE(wq) KERNEL$WQ_GET_ONE(wq)

#define WQ_WAKE_ONE(wq)							\
	(__barrier(), __likely(!WQ_EMPTY(wq)) ? KERNEL$WQ_WAKE_ONE(wq), 1 : 0)

#define WQ_WAKE_ALL(wq)							\
	(__barrier(), __unlikely(!WQ_EMPTY(wq)) ? KERNEL$WQ_WAKE_ALL(wq), 1 : 0)

#define WQ_WAKE_ALL_PL(wq)						\
	(__barrier(), KERNEL$WQ_WAKE_ALL(wq))

typedef struct {
	unsigned long lock;
	WQ wq;
} MTX;

#define __WQ_DUMP_MAGIC	"@WQDUMP"
#define WQ_DUMP()			\
do {					\
	WQ_DECL(__wq, __WQ_DUMP_MAGIC);	\
	KERNEL$WQ_WAKE_ONE(&__wq);	\
} while (0)

#if __DEBUG_WQ
#define MTX_DECL(symbol_, name_) MTX symbol_ = { 0, { &symbol_.wq, &symbol_.wq, { NULL, NULL }, (__const__ WQ_DESC *)(name_) } }
#else
#define MTX_DECL(symbol_, name_) MTX symbol_ = { 0, { &symbol_.wq, &symbol_.wq } }
#endif
#define MTX_INIT(mtx_, name_) ((mtx_)->lock = 0, WQ_INIT(&(mtx_)->wq, (name_)))

int KERNEL$MTX_LOCK_TEST(MTX *mtx);
int KERNEL$MTX_LOCK(MTX *mtx, IORQ *rq, int dontlock);
void KERNEL$MTX_LOCK_SYNC(MTX *mtx);
int KERNEL$MTX_LOCK_SYNC_CANCELABLE(MTX *mtx);
int KERNEL$MTX_LOCK_SYNC_SIGINTERRUPT(MTX *mtx);
int KERNEL$MTX_UNLOCK_TEST(MTX *mtx);
void KERNEL$MTX_UNLOCK(MTX *mtx);
void KERNEL$MTX_WAIT_SYNC(MTX *mtx);
int KERNEL$MTX_WAIT_SYNC_CANCELABLE(MTX *mtx);
int KERNEL$MTX_WAIT_SYNC_SIGINTERRUPT(MTX *mtx);
void KERNEL$MTX_SET(MTX *mtx, unsigned long val);

#define MTX_LOCK(mtx, io, fn, ret)				\
do {								\
	if (__unlikely(((io)->status & RQS_ACTION_MASK) != RQS_PROCESSING) || __unlikely(KERNEL$MTX_LOCK_TEST(mtx))) {				\
		(io)->tmp1 = (unsigned long) (fn);		\
		if (__unlikely(KERNEL$MTX_LOCK(mtx, (IORQ *)(void *)(io), 0))) {ret;}								\
	}							\
} while (0)

#define MTX_WAIT(mtx, io, fn)				\
do {							\
	(io)->tmp1 = (unsigned long) (fn);		\
	KERNEL$MTX_LOCK(mtx, (IORQ *)(void *)(io), 1);	\
} while (0)

#define MTX_TRY_LOCK(mtx)	(KERNEL$MTX_LOCK_TEST(mtx) != 0)

#define MTX_LOCK_SYNC(mtx)					\
do {								\
	if (__unlikely(KERNEL$MTX_LOCK_TEST(mtx))) KERNEL$MTX_LOCK_SYNC(mtx);\
} while (0)

#define MTX_LOCK_SYNC_CANCELABLE(mtx)				\
	(__likely(!KERNEL$MTX_LOCK_TEST(mtx)) ? 0 : KERNEL$MTX_LOCK_SYNC_CANCELABLE(mtx))

#define MTX_LOCK_SYNC_SIGINTERRUPT(mtx)				\
	(__likely(!KERNEL$MTX_LOCK_TEST(mtx)) ? 0 : KERNEL$MTX_LOCK_SYNC_SIGINTERRUPT(mtx))

	/* may return 1 always */
#define MTX_UNLOCK(mtx)						\
	(__unlikely(KERNEL$MTX_UNLOCK_TEST(mtx)) ? KERNEL$MTX_UNLOCK(mtx), 1 : 0)

#define MTX_WAIT_SYNC(mtx)					\
do {								\
	KERNEL$MTX_WAIT_SYNC(mtx);				\
} while (0)

#define MTX_WAIT_SYNC_CANCELABLE(mtx)				\
	(KERNEL$MTX_WAIT_SYNC_CANCELABLE(mtx))

#define MTX_WAIT_SYNC_SIGINTERRUPT(mtx)				\
	(KERNEL$MTX_WAIT_SYNC_SIGINTERRUPT(mtx))

#define MTX_GET(mtx)						\
	((mtx)->lock)

#define MTX_SET(mtx, val)					\
do {								\
	KERNEL$MTX_SET(mtx, val);				\
} while (0)

__END_DECLS

#endif
