/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)stdio.h	8.5 (Berkeley) 4/29/95
 * $FreeBSD: src/include/stdio.h,v 1.24.2.5 2002/11/09 08:07:20 imp Exp $
 */

#ifndef	_STDIO_H_
#define	_STDIO_H_

#include <SYS/TYPES.H>
#include <STDARG.H>

#ifndef NULL
#define	NULL	0
#endif

typedef	off_t		fpos_t;

/* These BSD people are freaky --- they put internal definition of FILE into
   exported include, together with few inlines that use it, fixing its layout
   forever. I have to rip it out before release, or I'll be stuck with it. */

typedef struct __sFILE FILE;

#define	_FSTDIO			/* Define for new stdio with functions. */

__BEGIN_DECLS
extern FILE *__stdinp, *__stdoutp, *__stderrp;
__END_DECLS

/*
 * The following three definitions are for ANSI C, which took them
 * from System V, which brilliantly took internal interface macros and
 * made them official arguments to setvbuf(), without renaming them.
 * Hence, these ugly _IOxxx names are *supposed* to appear in user code.
 *
 * Although numbered as their counterparts above, the implementation
 * does not rely on this.
 */
#define	_IOFBF	0		/* setvbuf should set fully buffered */
#define	_IOLBF	1		/* setvbuf should set line buffered */
#define	_IONBF	2		/* setvbuf should set unbuffered */

#define	BUFSIZ	1024		/* size of buffer used by setbuf */
#define	EOF	(-1)

/*
 * FOPEN_MAX is a minimum maximum, and is the number of streams that
 * stdio can provide without attempting to allocate further resources
 * (which could fail).  Do not use this for anything.
 *
 * since SPAD KERNEL.DLL allocates memory even for simple 'open' call, this
 * limit doesn't have any sense  -- mikulas
 */
				/* must be == _POSIX_STREAM_MAX <limits.h> */
#define	FOPEN_MAX	20	/* must be <= OPEN_MAX <sys/syslimits.h> */
#define	FILENAME_MAX	1024	/* must be <= PATH_MAX <sys/syslimits.h> */

/* System V/ANSI C; this is the wrong way to do this, do *not* use these. */
#ifndef _ANSI_SOURCE
#define	P_tmpdir	"TMP:/"
#endif
#define	L_tmpnam	1024	/* XXX must be == PATH_MAX */
#define	TMP_MAX		308915776

#ifndef SEEK_SET
#define	SEEK_SET	0	/* set file offset to offset */
#endif
#ifndef SEEK_CUR
#define	SEEK_CUR	1	/* set file offset to current plus offset */
#endif
#ifndef SEEK_END
#define	SEEK_END	2	/* set file offset to EOF plus offset */
#endif

#define	stdin	(__stdinp)
#define	stdout	(__stdoutp)
#define	stderr	(__stderrp)

/*
 * Functions defined in ANSI C standard.
 */
__BEGIN_DECLS
void	 clearerr __P((FILE *));
int	 fclose __P((FILE *));
int	 feof __P((FILE *));
int	 ferror __P((FILE *));
int	 fflush __P((FILE *));
int	 fgetc __P((FILE *));
int	 fgetpos __P((FILE *, fpos_t *));
char	*fgets __P((char *, int, FILE *));
FILE	*fopen __P((const char *, const char *));
int	 fprintf __P((FILE *, const char *, ...));
int	 fputc __P((int, FILE *));
int	 fputs __P((const char *, FILE *));
size_t	 fread __P((void *, size_t, size_t, FILE *));
FILE	*freopen __P((const char *, const char *, FILE *));
int	 fscanf __P((FILE *, const char *, ...));
int	 fseek __P((FILE *, long, int));
int	 fsetpos __P((FILE *, const fpos_t *));
long	 ftell __P((FILE *));
size_t	 fwrite __P((const void *, size_t, size_t, FILE *));
int	 getc __P((FILE *));
int	 getchar __P((void));
char	*gets __P((char *));
#if !defined(_ANSI_SOURCE)
extern __const int sys_nerr;		/* perror(3) external variables */
extern __const char *__const sys_errlist[];
#endif
void	 perror __P((const char *));
int	 printf __P((const char *, ...));
int	 putc __P((int, FILE *));
int	 putchar __P((int));
int	 puts __P((const char *));
int	 remove __P((const char *));
int	 rename  __P((const char *, const char *));
int	 renameat __P((int, const char *, int, const char *));
void	 rewind __P((FILE *));
int	 scanf __P((const char *, ...));
void	 setbuf __P((FILE *, char *));
int	 setvbuf __P((FILE *, char *, int, size_t));
int	 sprintf __P((char *, const char *, ...));
int	 sscanf __P((const char *, const char *, ...));
FILE	*tmpfile __P((void));
char	*tmpnam __P((char *));
int	 ungetc __P((int, FILE *));
int	 vfprintf __P((FILE *, const char *, va_list));
int	 vprintf __P((const char *, va_list));
int	 vsprintf __P((char *, const char *, va_list));
__END_DECLS

/*
 * Functions defined in POSIX 1003.1.
 */
#ifndef _ANSI_SOURCE
/* size for cuserid(3); UT_NAMESIZE + 1, see <utmp.h> */
#define	L_cuserid	17

#define	L_ctermid	1024	/* size for ctermid(3); PATH_MAX */

__BEGIN_DECLS
char	*cuserid __P((char *));
char	*ctermid __P((char *));
FILE	*fdopen __P((int, const char *));
int	 fileno __P((FILE *));
int	 ftrylockfile __P((FILE *));
void	 flockfile __P((FILE *));
void	 funlockfile __P((FILE *));
__END_DECLS
#endif /* not ANSI */

/*
 * Routines that are purely local.
 */
#if !defined (_ANSI_SOURCE)
__BEGIN_DECLS
int	 asprintf __P((char **, const char *, ...)) __PRINTF_ATTR__(2, 3);
char	*ctermid_r __P((char *));
char	*fgetln __P((FILE *, size_t *));
int	 fpurge __P((FILE *));
int	 fseeko __P((FILE *, off_t, int));
off_t ftello __P((FILE *));
int	 getw __P((FILE *));
int	 pclose __P((FILE *));
FILE	*popen __P((const char *, const char *));
int	 putw __P((int, FILE *));
void	 setbuffer __P((FILE *, char *, int));
int	 setlinebuf __P((FILE *));
char	*tempnam __P((const char *, const char *));
int	 snprintf __P((char *, size_t, const char *, ...)) __PRINTF_ATTR__(3, 4);
int	 vasprintf __P((char **, const char *, va_list))
	    __PRINTF_ATTR__(2, 0);
int	 vsnprintf __P((char *, size_t, const char *, va_list))
	    __PRINTF_ATTR__(3, 0);
int	 vscanf __P((const char *, va_list)) __SCANF_ATTR__(1, 0);
int	 vsscanf __P((const char *, const char *, va_list))
	    __SCANF_ATTR__(2, 0);
int	vfscanf __P((FILE *, const char *, va_list));
__END_DECLS

/*
 * Stdio function-access interface.
 */
__BEGIN_DECLS
FILE	*funopen __P((const void *,
		int (*)(void *, char *, int),
		int (*)(void *, const char *, int),
		fpos_t (*)(void *, fpos_t, int),
		int (*)(void *)));
FILE *fropen(const void *, int (*)(void *, char *, int));
FILE *fwopen(const void *, int (*)(void *, const char *, int));
__END_DECLS
#endif /* !_ANSI_SOURCE */

/*
 * See ISO/IEC 9945-1 ANSI/IEEE Std 1003.1 Second Edition 1996-07-12
 * B.8.2.7 for the rationale behind the *_unlocked() macros.
 */
int feof_unlocked(FILE *);
int ferror_unlocked(FILE *);
void clearerr_unlocked(FILE *);

#ifndef _ANSI_SOURCE
int fileno_unlocked(FILE *);
#endif

int getc_unlocked(FILE *);
int putc_unlocked(int, FILE *);
int getc(FILE *);
int putc(int, FILE *);

int getchar(void);
int getchar_unlocked(void);
int putchar(int);
int putchar_unlocked(int);

#endif /* !_STDIO_H_ */
