#ifndef __SYS_IOCTL_H
#define __SYS_IOCTL_H

#include <SYS/TYPES.H>
#include <TERMIOS.H>

__BEGIN_DECLS

int ioctl(int, unsigned long, ...);

#define FREAD				1
#define FWRITE				2
#define _FPUTBACK			4

#define TIOCGETA			0x001
#define TCGETS				TIOCGETA
#define TCGETA				TIOCGETA
#define TIOCSETA			0x002
#define TCSETS				TIOCSETA
#define TIOCSETAW			0x003
#define TCSETSW				TIOCSETAW
#define TCSETAW				TIOCSETAW
#define TIOCSETAF			0x004
#define TCSETSF				TIOCSETAF
#define TCSETAF				TIOCSETAF
#define TIOCSPGRP			0x005
#define TIOCGPGRP			0x006
#define TIOCSBRK			0x007
#define TIOCCBRK			0x008
#define TIOCDRAIN			0x009
#define TIOCFLUSH			0x00a
#define TIOCSTOP			0x00b
#define TIOCSTART			0x00c
#define TIOCGWINSZ			0x00d
#define TIOCSWINSZ			0x00e

#define FIONREAD			0x101
#define TIOCINQ				FIONREAD
#define FIOCLEX				0x102
#define FIONCLEX			0x103
#define FIONBIO				0x104

/*
#define FIOSETOWN			0x111
#define SIOCSPGRP			0x112
#define FIOGETOWN			0x113
#define SIOCGPGRP			0x114
*/

#define SNDCTL_DSP_RESET		0x201
#define SNDCTL_DSP_SYNC			0x202
#define SNDCTL_DSP_SPEED		0x203
#define SNDCTL_DSP_STEREO		0x204
#define SNDCTL_DSP_GETBLKSIZE		0x205
#define SNDCTL_DSP_SETFMT		0x206
#define SNDCTL_DSP_SAMPLESIZE		SNDCTL_DSP_SETFMT
#define SNDCTL_DSP_CHANNELS		0x207
#define SNDCTL_DSP_POST			0x208
#define SNDCTL_DSP_SUBDIVIDE		0x209
#define SNDCTL_DSP_SETFRAGMENT		0x20a
#define SNDCTL_DSP_GETFMTS		0x20b
#define SNDCTL_DSP_GETOSPACE		0x20c
#define SNDCTL_DSP_GETISPACE		0x20d
#define SNDCTL_DSP_NONBLOCK		0x20e
#define SNDCTL_DSP_GETCAPS		0x20f
#define SNDCTL_DSP_GETTRIGGER		0x210
#define SNDCTL_DSP_SETTRIGGER		0x211
#define SNDCTL_DSP_GETIPTR		0x212
#define SNDCTL_DSP_GETOPTR		0x213
#define SNDCTL_DSP_MAPINBUF		0x214	/* unimplemented */
#define SNDCTL_DSP_MAPOUTBUF		0x215	/* unimplemented */
#define SNDCTL_DSP_SETSYNCRO		0x216	/* unimplemented */
#define SNDCTL_DSP_SETDUPLEX		0x217
#define SNDCTL_DSP_GETODELAY		0x218
#define SNDCTL_DSP_GETERROR		0x219
#define SOUND_PCM_READ_RATE		0x21a
#define SOUND_PCM_READ_CHANNELS		0x21b
#define SOUND_PCM_READ_BITS		0x21c
#define SOUND_PCM_READ_FILTER		0x21d	/* unimplemented */
#define SOUND_PCM_WRITE_FILTER		0x21e	/* unimplemented */
#define SOUND_PCM_WRITE_BITS		SNDCTL_DSP_SETFMT
#define SOUND_PCM_WRITE_RATE		SNDCTL_DSP_SPEED
#define SOUND_PCM_WRITE_CHANNELS	SNDCTL_DSP_CHANNELS
#define SOUND_PCM_POST			SNDCTL_DSP_POST
#define SOUND_PCM_RESET			SNDCTL_DSP_RESET
#define SOUND_PCM_SYNC			SNDCTL_DSP_SYNC
#define SOUND_PCM_SUBDIVIDE		SNDCTL_DSP_SUBDIVIDE
#define SOUND_PCM_SETFRAGMENT		SNDCTL_DSP_SETFRAGMENT
#define SOUND_PCM_GETFMTS		SNDCTL_DSP_GETFMTS
#define SOUND_PCM_SETFMT		SNDCTL_DSP_SETFMT
#define SOUND_PCM_GETOSPACE		SNDCTL_DSP_GETOSPACE
#define SOUND_PCM_GETISPACE		SNDCTL_DSP_GETISPACE
#define SOUND_PCM_NONBLOCK		SNDCTL_DSP_NONBLOCK
#define SOUND_PCM_GETCAPS		SNDCTL_DSP_GETCAPS
#define SOUND_PCM_GETTRIGGER		SNDCTL_DSP_GETTRIGGER
#define SOUND_PCM_SETTRIGGER		SNDCTL_DSP_SETTRIGGER
#define SOUND_PCM_SETSYNCRO		SNDCTL_DSP_SETSYNCRO
#define SOUND_PCM_GETIPTR		SNDCTL_DSP_GETIPTR
#define SOUND_PCM_GETOPTR		SNDCTL_DSP_GETOPTR
#define SOUND_PCM_MAPINBUF		SNDCTL_DSP_MAPINBUF
#define SOUND_PCM_MAPOUTBUF		SNDCTL_DSP_MAPOUTBUF

#define _SOUND_MIXER_READ		0x240
#define _SOUND_MIXER_WRITE		0x280
#define _SOUND_MIXER_RW_SPACE		0x040

#define KDGKBMODE			0x301
#define KDSKBMODE			0x302
#define KDGETLED			0x303
#define KDSETLED			0x304

#define CDROMPAUSE			0x401
#define CDROMRESUME			0x402
#define CDROMPLAYMSF			0x403
#define CDROMPLAYTRKIND			0x404
#define CDROMREADTOCHDR			0x405
#define CDROMREADTOCENTRY		0x406
#define CDROMSTOP			0x407
#define CDROMSTART			0x408
#define CDROMEJECT			0x409
#define CDROMVOLCTRL			0x40a
#define CDROMSUBCHNL			0x40b
#define CDROMREADMODE2			0x40c
#define CDROMREADMODE1			0x40d
#define CDROMREADAUDIO			0x40e
#define CDROMEJECT_SW			0x40f
#define CDROMMULTISESSION		0x410
#define CDROM_GET_MCN			0x411
#define CDROM_GET_UPC			CDROM_GET_MCN
#define CDROMRESET			0x412
#define CDROMVOLREAD			0x413
#define CDROMREADRAW			0x414
#define CDROMREADCOOKED			0x415	/* unused */
#define CDROMSEEK			0x416	/* unused */
#define CDROMPLAYBLK			0x417
#define CDROMREADALL			0x418	/* unused */
#define CDROMCLOSETRAY			0x419
#define CDROMGETSPINDOWN		0x41d
#define CDROMSETSPINDOWN		0x41e
#define CDROM_SET_OPTIONS		0x420
#define CDROM_CLEAR_OPTIONS		0x421
#define CDROM_SELECT_SPEED		0x422
#define CDROM_SELECT_DISC		0x423
#define CDROM_MEDIA_CHANGED		0x425
#define CDROM_DRIVE_STATUS		0x426
#define CDROM_DISC_STATUS		0x427
#define CDROM_CHANGER_NSLOTS		0x428
#define CDROM_LOCKDOOR			0x429
#define CDROM_DEBUG			0x430
#define CDROM_GET_CAPABILITY		0x431
#define CDROMAUDIOBUFSIZ		0x482
#define DVD_READ_STRUCT			0x490
#define DVD_WRITE_STRUCT		0x491
#define DVD_AUTH			0x492
#define CDROM_SEND_PACKET		0x493
#define CDROM_NEXT_WRITABLE		0x494
#define CDROM_LAST_WRITTEN		0x495

#define FDGETPRM			0x501
#define FDGETMEDIAPRM			FDGETPRM
#define FDFLUSH				0x502

#define BLKFLSBUF			0x601

#define SCSI_IOCTL_GET_IDLUN		0x701
#define SCSI_IOCTL_PROBE_HOST		0x702
#define SCSI_IOCTL_GET_BUS_NUMBER	0x703
#define SG_GET_VERSION_NUM		0x781
#define SG_IO				0x782
#define SG_SET_RESERVED_SIZE		0x783
#define SG_GET_RESERVED_SIZE		0x784
#define SG_GET_SG_TABLESIZE		0x785
#define SG_SCSI_RESET			0x786
#define		SG_SCSI_RESET_NOTHING		0
#define		SG_SCSI_RESET_DEVICE		1
#define		SG_SCSI_RESET_BUS		2
#define		SG_SCSI_RESET_HOST		3
#define SG_EMULATED_HOST		0x787
#define SG_SET_TRANSFORM		0x788
#define SG_GET_TRANSFORM		0x789
#define SG_SET_TIMEOUT			0x78a
#define SG_GET_TIMEOUT			0x78b
#define SG_GET_PACK_ID			0x78c
#define SG_GET_BUFSIZE			0x78d

__END_DECLS

#endif
