#ifndef __SYS_SHM_H
#define __SYS_SHM_H

#include <SYS/TYPES.H>
#include <SYS/IPC.H>
#include <ARCH/PAGE.H>

__BEGIN_DECLS

#define SHM_RDONLY	010000
#define SHM_RND		020000

#define SHMLBA		__PAGE_CLUSTER_SIZE

typedef unsigned long shmatt_t;

struct shmid_ds {
	struct ipc_perm shm_perm;
	size_t shm_segsz;
	pid_t shm_lpid;
	pid_t shm_cpid;
	shmatt_t shm_nattch;
	time_t shm_atime;
	time_t shm_dtime;
	time_t shm_ctime;
};

int shmget(key_t, size_t, int);
void *shmat(int, const void *, int);
int shmdt(const void *);
int shmctl(int, int, struct shmid_ds *);

__END_DECLS

#endif
