#ifndef __SYS_SOCKET
#define __SYS_SOCKET

#include <ENDIAN.H>
#include <SYS/TYPES.H>

__BEGIN_DECLS

typedef __u32 sa_family_t;
typedef unsigned socklen_t;

#define AF_UNSPEC	0
#define PF_UNSPEC	AF_UNSPEC
#define AF_INET		__32CPU2BE_CONST(0x494E4554)
#define PF_INET		AF_INET
#define AF_MAX		0x7FFFFFFF

#define SOCK_STREAM	1
#define SOCK_DGRAM	2
/* when you define this, you must also define IPPROTO_RAW
#define SOCK_RAW	3
*/

#define __SO_MAKEPARAM(l, v)	(((l) << 16) | (v))
#define __SO_LEVEL(p)	((p) >> 16)
#define __SO_OPT(p)	((p) & 0xffff)

#define SOL_SOCKET	1

#define SO_DEBUG	1
#define SO_ACCEPTCONN	2
#define SO_REUSEADDR	3
#define SO_KEEPALIVE	4
#define SO_DONTROUTE	5
#define SO_BROADCAST	6
#define SO_OOBINLINE	7

#define SO_SNDBUF	32
#define SO_RCVBUF	33
#define SO_SNDLOWAT	34
#define SO_RCVLOWAT	35
#define SO_SNDTIMEO	36
#define SO_RCVTIMEO	37
#define SO_LINGER	38
#define SO_ERROR	39
#define SO_TYPE		40

#define SOMAXCONN	0x7fffffff

struct linger {
	int l_onoff;
	int l_linger;
};

struct sockaddr {
	unsigned sa_len;
	sa_family_t sa_family;
	char sa_data[8];
};

struct sockaddr_storage {
	unsigned ss_len;
	sa_family_t ss_family;
	char __ss_pad[112];
	__u64 __ss_align;
};

struct msghdr {
	void *msg_name;
	socklen_t msg_namelen;
	struct iovec *msg_iov;
	int msg_iovlen;
	void *msg_control;
	socklen_t msg_controllen;
	int msg_flags;
};

struct _msghdr {
	unsigned msg_flags;
	struct sockaddr msg_addr;
};

#define MSG_OOB			0x0001
#define MSG_PEEK		0x0002
#define MSG_DONTROUTE		0x0004
#define MSG_EOR			0x0008
#define MSG_TRUNC		0x0010
#define MSG_CTRUNC		0x0020
#define MSG_WAITALL		0x0040
#define MSG_DONTWAIT		0x0080
#define MSG_EOF			0x0100
#define MSG_NOSIGNAL		0x0200


#define SHUT_RD		0
#define SHUT_WR		1
#define SHUT_RDWR	2

int accept(int __h, struct sockaddr *__addr, socklen_t *__addrlen);
int bind(int __h, const struct sockaddr *__addr, socklen_t __addrlen);
int connect(int __h, const struct sockaddr *__addr, socklen_t __addrlen);
int getpeername(int __h, struct sockaddr *__addr, socklen_t *__addrlen);
int getsockname(int __h, struct sockaddr *__addr, socklen_t *__addrlen);
int getsockopt(int __h, int __level, int __opt, void *__optval, socklen_t *__optlen);
int listen(int __h, int __backlog);
ssize_t recv(int __h, void *__buf, size_t __size, int __flags);
ssize_t recvfrom(int __h, void *__buf, size_t __size, int __flags, struct sockaddr *__from, socklen_t *__from_len);
ssize_t recvmsg(int __h, struct msghdr *__msg, int __flags);
ssize_t send(int __h, const void *__buf, size_t __size, int __flags);
ssize_t sendto(int __h, const void *__buf, size_t __size, int __flags, const struct sockaddr *__from, socklen_t __from_len);
ssize_t sendmsg(int __h, const struct msghdr *__msg, int __flags);
ssize_t sendfile(int h, int in_h, off_t *offset, size_t count);
int setsockopt(int __h, int __level, int __opt, const void *__optval, socklen_t __optlen);
int shutdown(int __h, int __type);
int socket(int __domain, int __type, int __protocol);
int socketpair(int __domain, int __type, int __protocol, int *__fd);

__END_DECLS

#endif
