#ifndef __STAT_H
#define __STAT_H

#include <SYS/TYPES.H>

__BEGIN_DECLS

/* partially copied from EMX, (C) Eberhard Mattes */

#define S_IRWXU 00700
#define S_IRUSR 00400
#define S_IWUSR 00200
#define S_IXUSR 00100

#define S_IREAD		S_IRUSR
#define S_IWRITE	S_IWUSR
#define S_IEXEC		S_IXUSR

#define S_IRWXG 00070
#define S_IRGRP 00040
#define S_IWGRP 00020
#define S_IXGRP 00010

#define S_IRWXO 00007
#define S_IROTH 00004
#define S_IWOTH 00002
#define S_IXOTH 00001

#define S_ISVTX 01000
#define	S_ISGID 02000
#define	S_ISUID 04000

#define S_ISTXT		S_ISVTX

#define S_IFMT   0170000  /* Mask for file type */
#define S_IFIFO  0010000  /* Pipe */
#define S_IFCHR  0020000  /* Character device */
#define S_IFDIR  0040000  /* Directory */
#define S_IFBLK  0060000  /* Block device */
#define S_IFREG  0100000  /* Regular file */
#define S_IFLNK	 0120000  /* Symlink */
#define S_IFSOCK 0140000  /* Socket */
#define S_IFWHT  0160000  /* Whiteout (I don't know what is it) */

#define S_ISFIFO(mode) (((mode) & S_IFMT) == S_IFIFO)
#define S_ISCHR(mode)  (((mode) & S_IFMT) == S_IFCHR)
#define S_ISDIR(mode)  (((mode) & S_IFMT) == S_IFDIR)
#define S_ISBLK(mode)  (((mode) & S_IFMT) == S_IFBLK)
#define S_ISREG(mode)  (((mode) & S_IFMT) == S_IFREG)
#define S_ISLNK(mode)  (((mode) & S_IFMT) == S_IFLNK)
#define S_ISSOCK(mode) (((mode) & S_IFMT) == S_IFSOCK)
#define S_ISWHT(mode)  (((mode) & S_IFMT) == S_IFWHT)

#define	DEFFILEMODE	(S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH)

struct stat {
	off_t st_size;
	mode_t st_mode;
	nlink_t st_nlink;
	uid_t st_uid;
	gid_t st_gid;
	blksize_t st_blksize;	/* it is really optimal IO size */
	blkcnt_t st_blocks;
	time_t st_atime;
	time_t st_mtime;
	time_t st_ctime;
	ino_t st_ino;
	dev_t st_dev;
	dev_t st_rdev;
};

int fstat(int __h, struct stat *__buf);
int stat(__const__ char *__filename, struct stat *__buf);
int lstat(__const__ char *__filename, struct stat *__buf);
int fstatat(int __dirfd, __const__ char *__filename, struct stat *__buf, int __flags);

int fchmod(int __h, mode_t __mode);
int chmod(__const__ char *__filename, mode_t __mode);
int fchmodat(int __dirfd, __const__ char *__filename, mode_t __mode, int __flags);

int mkdir(__const__ char *__filename, mode_t __mode);
int mkdirat(int __dirfd, __const__ char *__filename, mode_t __mode);
int mknod(__const__ char *__filename, mode_t __mode, dev_t __dev);
int mknodat(int __dirfd, __const__ char *__filename, mode_t __mode, dev_t __dev);
int mkfifo(__const__ char *__pathname, mode_t __mode);
int mkfifoat(int __dirfd, __const__ char *__pathname, mode_t __mode);

mode_t umask(mode_t mask);

__END_DECLS

#endif
