#ifndef __SYS_WAIT_H
#define __SYS_WAIT_H

#include <SYS/TYPES.H>
#include <ENDIAN.H>

__BEGIN_DECLS

#define WNOHANG		1
#define WUNTRACED	2

#define WAIT_ANY	(-1)
#define WAIT_MYPGRP	0

pid_t wait(int *__status);
pid_t waitpid(pid_t __pid, int *__status, int __options);

#define WCOREFLAG		0x80
#define W_EXITCODE(ret, sig)	(((ret) << 8) | (sig))
#define W_STOPCODE(sig)		(((sig) << 8) | 0x7f)

#define WTERMSIG(status)	((status) & 0x7f)
#define WEXITSTATUS(status)	(((status) >> 8) & 0xff)
#define WSTOPSIG(status)	(WEXITSTATUS(status))

#define WIFEXITED(status)	(!WTERMSIG(status))
#define WIFSTOPPED(status)	(((status) & 0xff) == 0x7f)
#define WIFSIGNALED(status)	(!WIFSTOPPED(status) && !WIFEXITED(status))

#define WCOREDUMP(status)	((status) & WCOREFLAG)

union wait {
	int w_status;
	struct {
#ifdef __ENDIAN_LITTLE
		unsigned int __w_termsig:7;
		unsigned int __w_coredump:1;
		unsigned int __w_retcode:8;
		unsigned int __padding:16;
#endif
#ifdef __ENDIAN_BIG
		unsigned int __padding:16;
		unsigned int __w_retcode:8;
		unsigned int __w_coredump:1;
		unsigned int __w_termsig:7;
#endif
	} __wait_terminated;
	struct {
#ifdef __ENDIAN_LITTLE
		unsigned int __w_stopval:8;
		unsigned int __w_stopsig:8;
		unsigned int __padding:16;
#endif
#ifdef __ENDIAN_BIG
		unsigned int __padding:16;
		unsigned int __w_stopsig:8;
		unsigned int __w_stopval:8;
#endif
	} __wait_stopped;
};

#define w_termsig	__wait_terminated.__w_termsig
#define w_coredump	__wait_terminated.__w_coredump
#define w_retcode	__wait_terminated.__w_retcode
#define w_stopsig	__wait_stopped.__w_stopsig
#define w_stopval	__wait_stopped.__w_stopval

__END_DECLS

#endif
