#ifndef __TIME_H
#define __TIME_H

#include <SYS/TYPES.H>

#define CLK_TCK		100
#define CLOCKS_PER_SEC	CLK_TCK

__BEGIN_DECLS

time_t time(time_t *__p);
time_t __time32_2_time_t(__u32 __time32);
int stime(__const__ time_t *__t);

__END_DECLS

struct tm {
	int	tm_sec;		/* seconds after the minute [0-60] */
	int	tm_min;		/* minutes after the hour [0-59] */
	int	tm_hour;	/* hours since midnight [0-23] */
	int	tm_mday;	/* day of the month [1-31] */
	int	tm_mon;		/* months since January [0-11] */
	int	tm_year;	/* years since 1900 */
	int	tm_wday;	/* days since Sunday [0-6] */
	int	tm_yday;	/* days since January 1 [0-365] */
	int	tm_isdst;	/* Daylight Savings Time flag */
	long	tm_gmtoff;	/* offset from CUT in seconds */
	char	*tm_zone;	/* timezone abbreviation */
};

struct timespec {
	time_t tv_sec;
	long tv_nsec;
};

#define __ts_invalid(__ts)	(__unlikely((__ts)->tv_sec < 0) || __unlikely((unsigned long)(__ts)->tv_nsec >= 1000000000))

#ifndef	_ANSI_SOURCE
extern char *tzname[];
#endif

__BEGIN_DECLS
char *asctime __P((const struct tm *));
clock_t clock __P((void));
char *ctime __P((const time_t *));
double difftime __P((time_t, time_t));
struct tm *gmtime __P((const time_t *));
struct tm *localtime __P((const time_t *));
time_t mktime __P((struct tm *));
size_t strftime __P((char *, size_t, const char *, const struct tm *));

#ifndef _ANSI_SOURCE
void tzset __P((void));
#endif /* not ANSI */

#if !defined(_ANSI_SOURCE)
char *asctime_r __P((const struct tm *, char *));
char *ctime_r __P((const time_t *, char *));
struct tm *gmtime_r __P((const time_t *, struct tm *));
struct tm *localtime_r __P((const time_t *, struct tm *));
char *strptime __P((const char *, const char *, struct tm *));
char *timezone __P((int, int));
void tzsetwall __P((void));
time_t timelocal __P((struct tm * const));
time_t timegm __P((struct tm * const));

struct tm *offtime(const time_t * const, const long);
time_t timeoff(struct tm * const, const long);
time_t time2posix(time_t);
time_t posix2time(time_t);

#endif /* neither ANSI */

#if !defined(_ANSI_SOURCE) && defined(_P1003_1B_VISIBLE_HISTORICALLY)
/* Introduced in POSIX 1003.1b-1993, not part of 1003.1-1990. */
int clock_getres __P((clockid_t, struct timespec *));
int clock_gettime __P((clockid_t, struct timespec *));
int clock_settime __P((clockid_t, const struct timespec *));
#endif /* neither ANSI nor POSIX */
int nanosleep __P((const struct timespec *, struct timespec *));
__END_DECLS


#endif
