#include <SPAD/AC.H>
#include <SPAD/WQ.H>
#include <ERRNO.H>
#include <SPAD/ALLOC.H>
#include <ARCH/BITOPS.H>
#include <SPAD/LIBC.H>
#include <SPAD/ALLOC.H>
#include <KERNEL/SYSCALL.H>
#include <KERNEL/DEV.H>

void KERNEL$CIO(IORQ *RQ)
{
	IORQ *crq;
	unsigned long stat, pri;
	int spl = KERNEL$SPL;
	WQ *wq;
	/*a:*/
	crq = RQ;
	RAISE_SPL(SPL_TOP);
	b:
	stat = (pri = crq->status) & RQS_ACTION_MASK;
/*__debug_printf("cancel! (%08x)", pri);*/
	pri &= RQS_PRIORITY_MASK;
	if (stat == RQS_PROCESSING) {
		crq->status = RQS_WANTCANCEL;
		LOWER_SPLX(spl);
		return;
	}
	if (stat == RQS_CANCELABLE) {
		crq->status = RQS_CANCELING;
		LOWER_SPLX(spl);
		CALL_IORQ_LSTAT_EXPR(crq, (IO_STUB *)crq->tmp1);
		return;
	}
	if (stat == RQS_KERNELCANCELABLE) {
		if (__unlikely(__CMPXCHGL(&crq->status, RQS_KERNELCANCELABLE, RQS_CANCELING) != 0)) goto b;
		LOWER_SPLX(spl);
#if __DEBUG >= 1
		if (__unlikely(!FEATURE_TEST(FEATURE_USERSPACE))) KERNEL$SUICIDE("KERNEL$CIO: KERNEL CANCELABLE REQUEST IN KERNEL");
#endif
		SYSCALL2(SYS_CANCEL, (unsigned long)crq);
		return;
	}
	if (stat == RQS_CHAINCANCELABLE) {
		/*if (__unlikely(SPLX_BUSY(spl))) {	this loses chain
			LOWER_SPLX(spl);
			goto a;
		}*/
		crq->status = RQS_WANTCANCEL;
		crq = (IORQ *)crq->tmp2;
		goto b;
	}
	if (stat == RQS_WQCANCELABLE) {
		wq = __IORQ2WQ(crq);
		wq->next->prev = wq->prev;
		wq->prev->next = wq->next;
#if __DEBUG >= 2 && __DEBUG_WQ
		wq = wq->next;
		if (WQ_EMPTY(wq)) CHECK_WQ_EMPTY(wq);
#endif
		LOWER_SPLX(spl);
		crq->status = -EINTR;
		CALL_AST(crq);
		return;
	}
	LOWER_SPLX(spl);
	return;
}

DECL_IOCALL(KERNEL$WAIT_ON_FREEMEM, SPL_DEV, IORQ)
{
	WQ_WAIT(&KERNEL$FREEMEM_WAIT, RQ, KERNEL$SUCCESS);
	RETURN;
}

DECL_AST(KERNEL$AST_FREE, SPL_MALLOC, AST)
{
	free(RQ);
	RETURN;
}

