#include <KERNEL/DEV.H>
#include <KERNEL/SYSCALL.H>
#include <KERNEL/UDATA.H>
#include <LIB/KERNEL/UASM.H>
#include <LIB/KERNEL/UIO.H>
#include <SETJMP.H>
#include <KERNEL/LINK.H>
#include <SPAD/IOCTL.H>
#include <SPAD/SWAPPER.H>

#define HANDLE	POSIX_RESERVED_HANDLES

int _snprintf(char *str, size_t n, const char *fmt, ...)
{
	return 0;
}

static __NORET_ATTR__ void ex(long code, char *msg)
{
	while (1) SYSCALL3(SYS_EXIT, code, (unsigned long)msg);
}

static void * volatile IO_FLAG;

static DECL_AST(IO_DONE, SPL_TOP, IORQ)
{
	IO_FLAG = (void *)1;
	RETURN;
}

static void IO(void *rq_, unsigned long sysc)
{
	IORQ *rq = rq_;
	again:
	IO_FLAG = NULL;
	rq->fn = IO_DONE;
	rq->tmp3 = SPL_TOP;
	rq->status = 0;
	SYSCALL2(sysc, (unsigned long)rq);
	while (__unlikely(!IO_FLAG)) {
		SYSCALL3(SYS_BLOCK, (unsigned long)&IO_FLAG, 0);
	}
	if (__unlikely(rq->status == -EINTR)) goto again;
}

#include <KERNEL/LINKSIZE.I>

#define LIST_LOGICALS_BUFFER	2048

static DECL_LN_LIST_STAT(LIST_LOGICALS_BUFFER) ln_list_stat;

#define PATH_LENGTH	(__MAX_STR_LEN /* ln255: */ + 1 /* / */ + sizeof(struct link_header))

static char ideal_lname[__MAX_STR_LEN];
static char ideal_filename[PATH_LENGTH];

static __u8 file_content[sizeof(FFILE) + PATH_LENGTH + FILE_ALIGN - 1];

#define file	((FFILE *)(((unsigned long)file_content + FILE_ALIGN - 1) & ~(unsigned long)(FILE_ALIGN - 1)))

static int test_change(__u8 h[LINK_HASH_LENGTH])
{
	__u8 hash[LINK_HASH_LENGTH];
	AIORQ aio;
	aio.h = HANDLE;
	aio.v.ptr = (unsigned long)hash;
	aio.v.len = LINK_HASH_LENGTH;
	aio.v.vspace = &KERNEL$VIRTUAL;
	aio.pos = __offsetof(struct link_header, hash);
	aio.progress = 0;
	IO(&aio, SYS_AREAD);
	if (__unlikely(aio.status < 0)) {
		ex(aio.status, "UNABLE TO READ KERNEL.DLL");
	}
	if (__unlikely(aio.status != LINK_HASH_LENGTH)) {
		ex(-EFTYPE, "KERNEL.DLL TRUNCATED");
	}
	if (__likely(!memcmp(hash, h, LINK_HASH_LENGTH))) {
		return 0;
	}
	return 1;
}

static struct link_header l;

static void testlib(char *lnm)
{
#define u	((char *)&lh_tmp)
	static struct link_header lh_tmp;
	__u8 hash[LINK_HASH_LENGTH];
	unsigned rcount;
	AIORQ aio;
	int h1;

	stpcpy(stpcpy(file->path, lnm), ":/KERNEL.DLL");

	rcount = 0;

	retry:
	SYSCALL2(SYS_FAST_CLOSE, HANDLE);
	aio.h = HANDLE;
	aio.v.ptr = (unsigned long)hash;
	aio.v.len = LINK_HASH_LENGTH;
	aio.v.vspace = &KERNEL$VIRTUAL;
	aio.pos = __offsetof(struct link_header, hash);
	aio.progress = 0;
	IO(&aio, SYS_AREAD);
	h1 = aio.status;
	aio.v.ptr = (unsigned long)&lh_tmp;
	aio.v.len = sizeof lh_tmp;
	aio.v.vspace = &KERNEL$VIRTUAL;
	aio.pos = 0;
	aio.progress = 0;
	IO(&aio, SYS_AREAD);
	if (__likely(aio.status < 0)) return;
	if (__unlikely(aio.status != sizeof lh_tmp)) {
		unsigned n;
		int r = aio.status;
		if (__unlikely(r < 2) || __unlikely(memchr(u, '\n', r) != &u[r - 1]) || __unlikely(memchr(u, 0, r) != 0)) return;
		if (__unlikely(++rcount > LINK_MAX_RCOUNT)) return;
		r--;
		u[r] = 0;
		n = strcspn(u, ":/");
		if (u[n] == ':' && u[n + 1] == '/') {
			strcpy(file->path, u);
			goto retry;
		} else if (__likely(n) && __likely(u[n] != ':')) {
			char *p = strrchr(file->path, '/') + 1;
			if (__unlikely(p + strlen(u) >= file->path + PATH_LENGTH)) return;
			strcpy(p, u);
			goto retry;
		} else {
			return;
		}
	}
	if (__unlikely(h1 != LINK_HASH_LENGTH)) {
		return;
	}
	if (__unlikely(memcmp(&lh_tmp.hash, hash, LINK_HASH_LENGTH)) || __unlikely(test_change(hash))) {
		goto retry;
	}
	if (__unlikely(LINK_CHECK_HEADER(&lh_tmp, (void *)&KERNEL$LIST_END, (void *)&KERNEL$LIST_END, (void *)&KERNEL$LIST_END, (void *)&KERNEL$LIST_END, (void *)&KERNEL$LIST_END, NULL))) {
		return;
	}
	strcpy(ideal_lname, lnm);
	strcpy(ideal_filename, file->path);
	memcpy(&l, &lh_tmp, sizeof(struct link_header));
#undef u
}

#define data		(udata.vmmaps[0].vmaddr)
#define mem_size	((l.compressed_file_size + PAGE_CLUSTER_SIZE - 1) & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1))

static __NORET_ATTR__ void ex2(long code, char *msg)
{
	LD_GET_ERROR ldg;
	IOCTLRQ io;
	io.h = SWAPPER_HANDLE;
	io.v.ptr = (unsigned long)&ldg;
	io.v.len = sizeof ldg;
	io.v.vspace = &KERNEL$VIRTUAL;
	io.ioctl = IOCTL_SWAPPER_LDCACHE_GET_ERROR;
	io.param = (unsigned long)data;
	IO(&io, SYS_IOCTL);
	if (io.status >= 0) {
		if ((code == -EIO || code == -ENOENT || strlen(ldg.error) + 2 + strlen(msg) >= sizeof ldg.error)) {
		} else {
			memmove(ldg.error + strlen(msg) + 2, ldg.error, strlen(ldg.error) + 1);
			memcpy(stpcpy(ldg.error, msg), ": ", 2);
		}
		ex(code, ldg.error);
	} else {
		ex(code, msg);
	}
}

static void get_size(void)
{
	unsigned long code_size, rodata_size, data_size, bss_size;
	if (__unlikely(LINK_GET_SECTIONS_SIZE(data, &code_size, &rodata_size, &data_size, &bss_size, NULL))) {
		ex(-EFTYPE, "KERNEL.DLL CORRUPTED --- CAN'T GET SECTIONS SIZE");
	}
	udata.vmmaps[0].vmsize = (code_size + rodata_size + data_size + bss_size + PAGE_CLUSTER_SIZE - 1) & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1);
}

static int loadlib(void)
{
	union {
		AIORQ aio;
		IOCTLRQ io;
	} v;
	union {
		LD_PREPARE ldp;
		__u8 rel_digest[REL_DIGEST_LENGTH];
		LD_QUERY ldq;
	} u;
	strcpy(file->path, ideal_filename);
	SYSCALL2(SYS_FAST_CLOSE, HANDLE);
	udata.vmmaps[0].vmsize = mem_size;
	v.io.h = SWAPPER_HANDLE;
	v.io.v.ptr = (unsigned long)&u.ldq;
	v.io.v.len = sizeof u.ldq;
	v.io.v.vspace = &KERNEL$VIRTUAL;
	v.io.ioctl = IOCTL_SWAPPER_LDCACHE_ATTACH;
	v.io.param = 0;
	memcpy(u.ldq.h.hash, l.hash, LINK_HASH_LENGTH);
	memset(u.ldq.h.hash + LINK_HASH_LENGTH, 0, REL_DIGEST_LENGTH);
	u.ldq.addr = (unsigned long)data;
	IO(&v.io, SYS_IOCTL);
	if (__likely(!v.io.status)) {
		get_size();
		memcpy(udata.rel_digest, u.ldq.h.hash + LINK_HASH_LENGTH, REL_DIGEST_LENGTH);
		goto ret;
	}
	v.aio.h = HANDLE;
	v.aio.v.ptr = (unsigned long)data;
	v.aio.v.len = l.compressed_file_size;
	v.aio.v.vspace = &KERNEL$VIRTUAL;
	v.aio.pos = 0;
	v.aio.progress = 0;
	IO(&v.aio, SYS_AREAD);
	if (__unlikely(v.aio.status < 0)) {
		ex(v.aio.status, "UNABLE TO READ KERNEL.DLL");
	}
	if (__unlikely(test_change(l.hash))) {
		retry:
		udata.vmmaps[0].vmsize = PAGE_CLUSTER_SIZE;
		SYSCALL3(SYS_UNMAP_DEALLOC_RANGE, (unsigned long)udata.vmmaps[0].vmaddr, mem_size);
		return 1;
	}
	if (__unlikely(v.aio.status != l.compressed_file_size)) {
		ex(-EFTYPE, "KERNEL.DLL TRUNCATED");
	}
	get_size();

	v.io.h = SWAPPER_HANDLE;
	v.io.v.ptr = (unsigned long)&u.ldp;
	v.io.v.len = sizeof u.ldp;
	v.io.v.vspace = &KERNEL$VIRTUAL;
	v.io.ioctl = IOCTL_SWAPPER_LDCACHE_PREPARE;
	v.io.param = 0;
	u.ldp.from = (unsigned long)data;
	u.ldp.to = u.ldp.from + mem_size;
	IO(&v.io, SYS_IOCTL);
	if (__unlikely(v.io.status < 0)) {
		if (SWAPPER_STATUS_RETRY(v.io.status)) goto retry;
		ex(v.io.status, "CREATING LDCACHE FAILED");
	}

	v.io.v.ptr = 0;
	v.io.v.len = 0;
	v.io.ioctl = IOCTL_SWAPPER_LDCACHE_CHECK;
	v.io.param = (unsigned long)data;
	IO(&v.io, SYS_IOCTL);
	if (__unlikely(v.io.status < 0)) {
		if (SWAPPER_STATUS_RETRY(v.io.status)) goto retry;
		ex2(v.io.status, "VERIFYING LDCACHE FAILED");
	}
	v.io.ioctl = IOCTL_SWAPPER_LDCACHE_RELOC;
	IO(&v.io, SYS_IOCTL);
	if (__unlikely(v.io.status < 0)) {
		if (SWAPPER_STATUS_RETRY(v.io.status)) goto retry;
		ex2(v.io.status, "RELOCATING FAILED");
	}
	v.io.v.ptr = (unsigned long)u.rel_digest;
	v.io.v.len = REL_DIGEST_LENGTH;
	v.io.ioctl = IOCTL_SWAPPER_LDCACHE_FINALIZE;
	IO(&v.io, SYS_IOCTL);
	if (__unlikely(v.io.status < 0)) {
		if (SWAPPER_STATUS_RETRY(v.io.status)) goto retry;
		ex2(v.io.status, "FINALIZING LDCACHE FAILED");
	}
	memcpy(udata.rel_digest, u.rel_digest, REL_DIGEST_LENGTH);

	ret:
	return 0;
}

#undef data
#undef mem_size

void BOOTSTRAP(void);

void BOOTSTRAP(void)
{
	long r;
	udata.handles[HANDLE] = file;
	complete_restart:
	file->pos = 0;
	file->flags = _O_KRNL_READ;
	file->l_refcount = 1;
	file->aux = 0;
	INIT_XLIST(&file->blobs);
	ideal_filename[0] = 0;
	ln_list_stat.depth = 0;
	ln_list_stat.hash = 0;
	ln_list_stat.ptr = NULL;
	while (__likely((r = SYSCALL3(SYS_LN_LIST, (unsigned long)&ln_list_stat, LIST_LOGICALS_BUFFER)) >= 0)) {
		char *end = ln_list_stat.result + r;
		char *ptr = ln_list_stat.result;
		ln_list_stat.depth = ln_list_stat.depth_res;
		ln_list_stat.hash = ln_list_stat.hash_res;
		ln_list_stat.ptr = ln_list_stat.ptr_res;
		while (ptr != end) {
			if (__likely(ptr[0] != 'L') ||
			    __unlikely(ptr[1] != 'I') ||
			    __unlikely(ptr[2] != 'B')) goto cont;
			if (!ideal_filename[0] || strcmp(ptr, ideal_lname) < 0) {
				testlib(ptr);
			}
			cont:
			ptr += strlen(ptr) + 1;
		}
		if (__likely(ln_list_stat.depth < 0)) break;
	}
	if (__unlikely(!ideal_filename[0])) {
		ex(-ENOENT, "UNABLE TO FIND KERNEL.DLL");
	}
	if (loadlib()) goto complete_restart;
	udata.handles[HANDLE] = NULL;
	SYSCALL2(SYS_FAST_CLOSE, HANDLE);
}

