#ifndef __KERNEL_DEV_H
#define __KERNEL_DEV_H

#include <SPAD/DEV_KRNL.H>
#include <SPAD/LIST.H>
#include <SPAD/WQ.H>
#include <STDLIB.H>
#include <ARCH/SETUP.H>

/* UNX */

int retry_eintr(int h);
const char *open_translate_unx(const char *path, const char **to_free);

/* WQ */

#if __DEBUG >= 1
void CHECK_RQ_STATE(IORQ *io);
#else
#define CHECK_RQ_STATE(x) do { } while (0)
#endif

#if __DEBUG >= 2 && __DEBUG_WQ
void CHECK_WQ_EMPTY(WQ *wq);
#endif

void SUSPEND_KERNEL_AST(IORQ *rq);
void RESUME_KERNEL_AST(IORQ *rq);

extern MTX DEV_MUTEX;

/* HANDLE */

static __finline__ VMENTITY *HANDLE_TO_VMENTITY(HANDLE *h)
{
	return (VMENTITY *)(h + 1);
}

static __finline__ HANDLE *VMENTITY_TO_HANDLE(VMENTITY *e)
{
	return (HANDLE *)e - 1;
}

extern const HANDLE_OPERATIONS empty_handle;
extern const HANDLE_OPERATIONS KERNEL_HANDLE_NOOP;
HANDLE *GET_HANDLE_TEST(PROC *proc, int handle_num, int incomplete);
HANDLE *GET_HANDLE_FAST_INTERNAL(PROC *proc, int handle_num);
HANDLE *GET_HANDLE(PROC *proc, int handle_num, int open_flags, IORQ *rq);

/* cmd is called if
	- error must be checked
	or
	- some other handle might have been freed
*/
#define GET_HANDLE_FAST(handle, proc, handle_num, open_flags, rq, cmd)	\
{									\
	(handle) = GET_HANDLE_FAST_INTERNAL(proc, handle_num);		\
	if (__unlikely(!(handle))) {					\
		(handle) = GET_HANDLE(proc, handle_num, open_flags, rq);\
		cmd;							\
	}								\
}

extern XLIST_HEAD PENDING_DELETE_LIST;
int UNREF_FILE(FFILE *f);
void SET_FILE_BLOB(FFILE *f, FBLOB_REF *br, FBLOB *bl, void **to_free_1, void **to_free_2);
void FREE_PIPE_INTERNAL(FFILE *f);
static __finline__ void FREE_PIPE(FFILE *f)
{
	if (__unlikely((f->flags & (_O_PIPE | _O_KRNL_FORKED)) == _O_PIPE))
		FREE_PIPE_INTERNAL(f);
}

int CHECK_HANDLE(int h);

void SOCKET_CLEANUP(void);

extern const HANDLE_OPERATIONS VIRTUAL_OPERATIONS;

void *VIRTUAL_MAP(VDESC *desc, int rw, int spl, vspace_unmap_t **unmap);
vspace_dmaunlock_t *VIRTUAL_DMALOCK(VDESC *desc, int rw, VDMA *dma);
vspace_dma64unlock_t *VIRTUAL_DMA64LOCK(VDESC *desc, int rw, VDMA64 *dma);
vspace_physunlock_t *VIRTUAL_PHYSLOCK(VDESC *desc, int rw, VPHYS *dma);

extern AST_STUB bio_emu_endrq;

/* LNT */

#define LNT_HASH_SIZE		32

typedef struct {
	XLIST_HEAD hash[LNT_HASH_SIZE];
} LNT;

extern LNT *LN;

typedef struct {
	LIST_ENTRY hash;	/* entry in LNT->hash */
	int handle;		/* handle and LNTE_xxx flags */
	void *dev_ptr;
	__DCALL *dcall;
	const char *dcall_type;
	__DCTL *dctl;
	__DCTL *unload;
	const char *driver_name;
	LIST_ENTRY depwalk;
	char **deps;
	unsigned n_deps;
	unsigned char user;		/* used in libproc */
	char name[1];
} LNTE;

int LN_TEST_RECURSIVE_DEPENDENCIES(LNTE *lnte, int (*init)(LNTE *, void *), int (*test)(LNTE *, void *), void *p);
int LN_INIT_VM(LNTE *lnte, void *p);
int LN_TEST_EQ(LNTE *lnte, void *p);
void UNBLOCK_LNT(void);


void SORT_LOGICAL_LIST(LOGICAL_LIST_REQUEST *r);

#define DECL_LN_LIST_STAT(n)	\
struct {			\
	int depth;		\
	unsigned hash;		\
	void *ptr;		\
	int depth_res;		\
	unsigned hash_res;	\
	void *ptr_res;		\
	char result[n];		\
}

struct ln_list_internal {
	int depth;
	unsigned hash;
	void *ptr;
	PROC *proc;
	char *result_addr;
	long result_left;
	unsigned char success;
	u_jiffies_lo_t j;
};

int get_lnm(struct ln_list_internal *ln_list_internal);

/* LIBPROC */

extern struct subproc_ctl *SUBPROC_CTL;
void LIBPROC_CLEANUP(int sigkill);

void CLEAR_SUBPROC_LN_CACHE(void);
void SWAP_ALL_SUBPROCESSES(void);
void USR_SWAP_ALL_HANDLES(void);



void MULTIOPEN(OPENRQ *RQ, FFILE *f);
void MULTIOPEN_CLEAR_CACHE(void);
int MULTIOPEN_ERROR_PRI(int error);

int _dup_noposix(int h, IORQ *rq, IO_STUB *fn);

void set_pipe_buffer(int h, FPIPE *buf);
int substitute_option(char *src, char *dest, char *option, char *value);

void DEV_INIT(void);

off_t slow_lseek(int h, off_t offset, int whence);
int is_exec(const char *p);
int is_cmd(const char *p);

struct __cwd {
	XLIST_HEAD cwds;
};

typedef struct {
	LIST_ENTRY list;
	unsigned lnlen;
	unsigned len;
	char *name;
} CWDE;

static __finline__ FFILE *open_file_name(OPENRQ *rq, unsigned *size)
{
	const char *p = rq->path;
	char *q, *qq, *o;
	char c;
	FFILE *f;
	CWDE *cwde;
	unsigned l;
	*size = 0;	/* shut up warning */
	l = strlen(rq->path);
	while (__likely(*p) && __likely(*p != '/')) if (__unlikely(*p++ == ':')) {
		if (__likely(*p == '/')) {
			f = malloc(sizeof(FFILE) + l);
			if (__unlikely(!f)) {
				*size = sizeof(FFILE) + l;
				return __ERR_PTR(-ENOMEM);
			}
			/*f->path[-1] = '.'; this was a test*/
			memcpy(f->path, rq->path, l + 1);
			q = f->path + (p - rq->path) + 1;
			goto ret_f;
		}
		if (__likely(rq->cwd != NULL) && __likely(!getenv("KERNEL$ABS_LN_OPEN"))) XLIST_FOR_EACH(cwde, &rq->cwd->cwds, CWDE, list) if (cwde->lnlen == p - rq->path - 1 && !_memcasecmp(cwde->name, rq->path, cwde->lnlen)) {
			f = malloc(sizeof(FFILE) + 1 + cwde->len + l - (p - rq->path));
			if (__unlikely(!f)) {
				*size = sizeof(FFILE) + 1 + cwde->len + l - (p - rq->path);
				return __ERR_PTR(-ENOMEM);
			}
			memcpy(f->path, cwde->name, cwde->len);
			f->path[cwde->len] = '/';
			memcpy(f->path + cwde->len + 1, p, l + 1 - (p - rq->path));
			q = f->path + cwde->lnlen + 2;
			goto ret_f;
		}
		{
			f = malloc(sizeof(FFILE) + 1 + l);
			if (__unlikely(!f)) {
				*size = sizeof(FFILE) + 1 + l;
				return __ERR_PTR(-ENOMEM);
			}
			memcpy(f->path, rq->path, p - rq->path);
			f->path[p - rq->path] = '/';
			memcpy(f->path + (p - rq->path) + 1, p, l - (p - rq->path) + 1);
			q = f->path + (p - rq->path) + 1;
			goto ret_f;
		}
	}
	if (__unlikely(!rq->cwd) || __unlikely(XLIST_EMPTY(&rq->cwd->cwds))) {
		return __ERR_PTR(-ENOCWD);
	}
	cwde = LIST_STRUCT(rq->cwd->cwds.next, CWDE, list);
	if (__unlikely(*rq->path == '/')) {
		f = malloc(sizeof(FFILE) + 1 + cwde->lnlen + l);
		if (__unlikely(!f)) {
			*size = sizeof(FFILE) + 1 + cwde->lnlen + l;
			return __ERR_PTR(-ENOMEM);
		}
		memcpy(f->path, cwde->name, cwde->lnlen + 1);
		memcpy(f->path + cwde->lnlen + 1, rq->path, l + 1);
		q = f->path + cwde->lnlen + 2;
		goto ret_f;
	}
	{
		f = malloc(sizeof(FFILE) + 1 + cwde->len + l);
		if (__unlikely(!f)) {
			*size = sizeof(FFILE) + 1 + cwde->len + l;
			return __ERR_PTR(-ENOMEM);
		}
		memcpy(f->path, cwde->name, cwde->len);
		f->path[cwde->len] = '/';
		memcpy(f->path + cwde->len + 1, rq->path, l + 1);
		q = f->path + cwde->lnlen + 2;
		goto ret_f;
	}

	ret_f:
	o = qq = q;
	nxd:
	while (__unlikely(*o == '/')) o++;
	if (__unlikely(o[0] == '.')) {
		if (__likely(o[1] == '.')) {
			if (__likely(o[2] == '/')) {
				if (__likely(q != qq)) {
					q--;
					do q--; while (q >= qq && *q != '/');
					q++;
				}
				o += 3;
				goto nxd;
			}
			if (__unlikely(!o[2])) {
				q--;
				do q--; while (q >= qq && *q != '/');
				if (__likely(q >= qq)) *q++ = 0;
				else *qq = 0;
				goto ret;
			}
		}
		if (__unlikely(o[1] == '/')) {
			o += 2;
			goto nxd;
		}
		if (__unlikely(!o[1])) {
			if (__likely(q > qq)) q[-1] = 0;
			else *qq = 0;
			goto ret;
		}
	}
	nxch:
	c = *q++ = *o++;
	if (__unlikely(!c)) {
		ret:
		if (__likely(q > qq + 1) && __unlikely(q[-2] == '/')) q[-2] = 0;
		*size = __likely(qq >= f->path + 3) && __unlikely(qq[-3] == '.');
		return f;
	}
	if (__likely(c != '/')) goto nxch;
	goto nxd;
}

#endif

