#include <SPAD/DL.H>
#include <KERNEL/DEV.H>
#include <STDLIB.H>

static AST_STUB DL_LOADED_MODULE;
static AST_STUB DL_UNLOADED_MODULE;
static AST_STUB DL_MAIN_RETURN;

MTX_DECL(KERNEL$DMAN_MUTEX, "KERNEL$DMAN_MUTEX");

DECL_IOCALL(KERNEL$DL_LOAD_IMAGE, SPL_DL, DLIMGRQ)
{
	DLRQ *d;
	if (RQ->device) MTX_LOCK(&DEV_MUTEX, RQ, KERNEL$DL_LOAD_IMAGE, RETURN);
	d = malloc(sizeof(DLRQ) + sizeof(DLIMGRQ *));
	if (__unlikely(!d)) {
		if (__likely(!KERNEL$OOM(VM_TYPE_WIRED_MAPPED))) {
			WQ_WAIT(&KERNEL$FREEMEM_WAIT, RQ, KERNEL$DL_LOAD_IMAGE);
			if (RQ->device) MTX_UNLOCK(&DEV_MUTEX);
			RETURN;
		}
		RQ->status = -ENOMEM;
		_snprintf(RQ->error, __MAX_STR_LEN, "OUT OF MEMORY");
		if (RQ->device) MTX_UNLOCK(&DEV_MUTEX);
		RETURN_AST(RQ);
	}
	d->fn = &DL_LOADED_MODULE;
	d->type = 0;
	*(DLIMGRQ **)(d + 1) = RQ;
	RQ->handle = d;
	strlcpy(d->filename, RQ->filename, __MAX_STR_LEN);
	strcpy(d->modname, !RQ->device ? "IMG" : "DEV");
	d->error[0] = 0;
	RETURN_IORQ_CANCELABLE(d, &KERNEL$DL_LOAD_MODULE, RQ);
}

static DECL_AST(DL_LOADED_MODULE, SPL_DL, DLRQ)
{
	char *start;
	unsigned long mn;
	DLIMGRQ *rq = *(DLIMGRQ **)(RQ + 1);
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_DL), rq);
	if (__unlikely(RQ->status < 0)) {
		strlcpy(rq->error, RQ->error, __MAX_STR_LEN);
		rq->status = RQ->status;
		free(RQ);
		if (rq->device) MTX_UNLOCK(&DEV_MUTEX);
		RETURN_AST(rq);
	}
	start = "_START";
	if (__unlikely(KERNEL$DL_GET_SYMBOL(rq->handle, start, &mn))) {
		rq->status = -EINVAL;
		_snprintf(rq->error, __MAX_STR_LEN, "%s NOT FOUND", start);
		RQ->fn = &DL_UNLOADED_MODULE;
		RETURN_IORQ(RQ, &KERNEL$DL_UNLOAD_MODULE);
	}
	if (rq->device) KERNEL$HEAP_CHECK(RQ->filename);
	*rq->error = 0;
	rq->t.tsr = 0;
	rq->t.thread_main = (long (*)(void *))mn;
	rq->t.p = &rq->a;
	rq->a.argv = rq->argv;
	rq->a.env = environ;
	rq->t.fn = DL_MAIN_RETURN;
	rq->t.error = rq->error;
	rq->t.cwd = rq->cwd;
	rq->t.std_in = rq->std_in;
	rq->t.std_out = rq->std_out;
	rq->t.std_err = rq->std_err;
	rq->t.dlrq = rq->handle;
	rq->t.thread = NULL;
	rq->t.spawned = 0;
	RETURN_IORQ_CANCELABLE(&rq->t, KERNEL$THREAD, rq);
}

static DECL_AST(DL_MAIN_RETURN, SPL_DL, THREAD_RQ)
{
	DLIMGRQ *rq = GET_STRUCT(RQ, DLIMGRQ, t);
	DLRQ *dlrq = rq->handle;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_DL), rq);
	rq->status = RQ->status;
	if (__unlikely(!RQ->spawned)) _snprintf(rq->error, __MAX_STR_LEN, "ERROR SPAWNING THREAD: %s", strerror(-rq->status));
	if (rq->device) KERNEL$HEAP_CHECK(rq->filename);
	if (rq->t.tsr) {
		if (rq->device) MTX_UNLOCK(&DEV_MUTEX);
		RETURN_AST(rq);
	}

	dlrq->fn = &DL_UNLOADED_MODULE;
	RETURN_IORQ(dlrq, &KERNEL$DL_UNLOAD_MODULE);
}

static DECL_AST(DL_UNLOADED_MODULE, SPL_DL, DLRQ)
{
	DLIMGRQ *rq = *(DLIMGRQ **)(RQ + 1);
	free(RQ);
	if (rq->device) MTX_UNLOCK(&DEV_MUTEX);
	RETURN_AST(rq);
}

