#include <SYS/TYPES.H>
#include <ARCH/CPU.H>
#include <STRING.H>
#include <STDLIB.H>
#include <KERNEL/SMP/SHARE.H>

#include <KERNEL/FEATURE.H>

static int cmp_features(const void *p1, const void *p2)
{
	feature_t v1 = *(const feature_t *)p1;
	feature_t v2 = *(const feature_t *)p2;
	if (v1 < v2) return -1;
	if (v1 > v2) return 1;
	return 0;
}

void FEATURE_ADD(feature_t feature)
{
	if (FEATURE_FIND(FEATURE_BOX, feature))
		return;
	if (FEATURE_BOX[0] >= _FEATURE_BOX_SIZE - 1)
		FEATURE_ADD_FAILURE();
	FEATURE_BOX[++FEATURE_BOX[0]] = feature;
	qsort(FEATURE_BOX + 1, FEATURE_BOX[0], sizeof(feature_t), cmp_features);
}

void FEATURE_DEL(feature_t feature)
{
	unsigned idx = FEATURE_FIND(FEATURE_BOX, feature);
	if (!idx) return;
	memmove(&FEATURE_BOX[idx], &FEATURE_BOX[idx + 1], (FEATURE_BOX[0]-- - idx) * sizeof(feature_t));
}

int KERNEL$FEATURE_TEST(__u32 feature)
{
	return !!FEATURE_FIND(FEATURE_BOX, feature);
}

#if __KERNEL_SUPPORT_SMP

void FEATURE_SMPSYNC(void)
{
	__cpu_id_t c;
	unsigned i;
	feature_t *box = GET_KERNEL_VAR(FEATURE_BOX, 0);
	for (i = 1; i <= FEATURE_BOX[0]; i++) {
		if (!FEATURE_FIND(box, FEATURE_BOX[i])) {
			FEATURE_DEL(FEATURE_BOX[i]);
			i--;
		}
	}
	for_other_cpus(c) {
		box = GET_KERNEL_VAR(FEATURE_BOX, c);
		memcpy(box, FEATURE_BOX, (FEATURE_BOX[0] + 1) * sizeof(feature_t));
	}
}

#endif
