#ifndef __KERNEL_FEATURE_H
#define __KERNEL_FEATURE_H

#include <SYS/TYPES.H>
#include <ARCH/CPU.H>
#include <SPAD/LINK.H>

typedef __u32 feature_t;

extern feature_t FEATURE_BOX[_FEATURE_BOX_SIZE];

unsigned FEATURE_FIND(feature_t box[_FEATURE_BOX_SIZE], feature_t feature);
void FEATURE_ADD(feature_t feature);
void FEATURE_DEL(feature_t feature);
void FEATURE_ADD_FAILURE(void) __NORET_ATTR__;

int FEATURE_FIXUP(struct feature_fixup *start, struct feature_fixup *end);

void FEATURE_SMPSYNC(void);

int FEATURE_FIND_VARIABLE(feature_t feature, __f_off *start, __f_off *end);
int FEATURE_USER_TEST(__u32 feature, int (*test)(__u32 feature));

#endif
